% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{rmse}
\alias{rmse}
\title{Calculate root mean squared error.}
\usage{
rmse(y_true = NULL, y_pred = NULL, actual = NULL, forecast = NULL,
  na.rm = TRUE, ...)
}
\arguments{
\item{y_true}{Ground truth (correct) target values.}

\item{y_pred}{Estimated target values.}

\item{actual}{a numeric vector of actuals.}

\item{forecast}{a numeric vector of forecasts.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{...}{additional arguments to be passed to mean()}
}
\value{
a numeric vector of length one: the mean of of absolute percent errors.
}
\description{
\code{rmse} takes actual and forecast numeric vectors and returns a
numeric vector where forecast is subtracted from the actual,
the errors are then squared, the average of those squared error is
taken, and lastly, the root taken of that mean squared error value.
}
\examples{
# Examples
rmse(1:100, 100:1)
}

