% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_hclust.R
\name{step_aggregate_hclust}
\alias{step_aggregate_hclust}
\alias{tidy.step_aggregate_hclust}
\title{Feature aggregation step based on a hierarchical clustering}
\usage{
step_aggregate_hclust(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  n_clusters,
  fun_agg,
  dist_metric = "euclidean",
  linkage_method = "complete",
  res = NULL,
  prefix = "cl_",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("aggregate_hclust")
)

\method{tidy}{step_aggregate_hclust}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \code{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{n_clusters}{Number of cluster to create.}

\item{fun_agg}{Aggregation function like \code{sum} or \code{mean}.}

\item{dist_metric}{Default to \code{euclidean}. See \code{\link[stats:dist]{stats::dist()}} for more
details.}

\item{linkage_method}{Default to \code{complete}. See \code{\link[stats:hclust]{stats::hclust()}} for more
details.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{prefix}{A character string for the prefix of the resulting new
variables.}

\item{keep_original_cols}{A logical to keep the original variables in
the output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_aggregate_hclust} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Aggregate variables according to hierarchical clustering.
}
\examples{
rec <-
  iris \%>\%
  recipe(formula = Species ~ .) \%>\%
  step_aggregate_hclust(all_numeric_predictors(),
                        n_clusters = 2, fun_agg = sum) \%>\%
  prep()
rec
tidy(rec, 1)
bake(rec, new_data = NULL)
}
\author{
Antoine Bichat
}
