% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scdhlm-package.r
\docType{package}
\name{scdhlm}
\alias{scdhlm}
\title{scdhlm}
\description{
Standardize mean difference effect size estimation based on hierarchical models
for single-case designs.
}
\details{
\pkg{scdhlm} implements methods for estimating a design-comparable standardized 
mean difference effect size based on data from a single-case design. 
The following functions are available:
\itemize{
\item \code{\link{g_REML}} implements the corrected REML estimator for a fitted \code{lme} model,
as described in Pustejovsky, Hedges, and Shadish (2014).
\item \code{\link{effect_size_MB}} implements the HPS estimator for the multiple baseline design,
as described in Hedges, Pustejovsky, and Shadish (2013).
\item \code{\link{effect_size_ABk}} implements the HPS estimator for the (AB)^k design,
as described in Hedges, Pustejovsky, and Shadish (2012).
}

The package also includes the data used in the examples from each paper, as well as several other datasets: 
\itemize{
\item \code{\link{AlberMorgan}}
\item \code{\link{Anglesea}}
\item \code{\link{BartonArwood}}
\item \code{\link{Bryant2018}}
\item \code{\link{Carson}}
\item \code{\link{Lambert}}
\item \code{\link{Laski}}
\item \code{\link{Musser}}
\item \code{\link{Rodriguez}}
\item \code{\link{Ruiz}}
\item \code{\link{Saddler}}
\item \code{\link{Schutte}}
\item \code{\link{Thiemann2001}}
\item \code{\link{Thiemann2004}}
\item \code{\link{Thorne}}
}
}
\references{
Hedges, L. V., Pustejovsky, J. E., & Shadish, W. R. (2012).
A standardized mean difference effect size for single case designs. 
\emph{Research Synthesis Methods, 3}, 224-239. doi:\href{http://doi.org/10.1002/jrsm.1052}{10.1002/jrsm.1052}

Hedges, L. V., Pustejovsky, J. E., & Shadish, W. R. (2013). 
A standardized mean difference effect size for multiple baseline designs across individuals. 
\emph{Research Synthesis Methods, 4}(4), 324-341. doi:\href{http://doi.org/10.1002/jrsm.1086}{10.1002/jrsm.1086}

Pustejovsky, J. E., Hedges, L. V., & Shadish, W. R. (2014). 
Design-comparable effect sizes in multiple baseline designs: A general modeling framework.
\emph{Journal of Educational and Behavioral Statistics, 39}(4), 211-227. doi:\href{http://doi.org/10.3102/1076998614547577}{10.3102/1076998614547577}
}
\author{
James E. Pustejovsky <jepusto@gmail.com>
}
