% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{if_connected}
\alias{if_connected}
\title{Return a set of the location and its neighbors if they are connected,
else return the empty set.}
\usage{
if_connected(distinct_neighbors, location, adjacency_matrix)
}
\arguments{
\item{distinct_neighbors}{A \code{set} containing the neighboring locations
to the given location, not including the location itself.}

\item{location}{A location, preferably given as an integer.}

\item{adjacency_matrix}{A boolean matrix, with element \eqn{(i,j)} set 
to TRUE if location \eqn{j} is adjacent to location \eqn{i}.}
}
\value{
A \code{set} of the given location and the neighbors if they are
   connected, else returns the empty set.
}
\description{
If the location and its neighbors, not including itself, are connected,
then return the set containing the location and its neighbors;
otherwise, return the empty set
}
\keyword{internal}
