% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSC.R
\name{writeSC}
\alias{writeSC}
\title{Export data into a .csv-file}
\usage{
writeSC(data, filename = NULL, sep = ",", dec = ".", ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{filename}{A character string defining the output file name (e.g.
\code{"SC_data.csv"}.}

\item{sep}{The field separator string. Values within rows will be separated
by this string. Default is \code{sep = ","}.}

\item{dec}{The string used for decimal points. Must be a single character.
Default is \code{dec = "."}}

\item{\dots}{Further arguments passed to write.table.}
}
\description{
This function restructures and exports single-case data into a .csv-file.
}
\examples{
## Write single-case data to a .csv-file
filename <- tempfile()
jessica <- rSC(design_rSC(level = .5))
writeSC(jessica, filename)

## Write multiple cases to a .csv-file with semicolon as field and comma as decimal separator
writeSC(Grosche2011, filename, sep = ";", dec = ",")

## writeSC and readSC
writeSC(exampleA1B1A2B2_zvt, filename)
dat <- readSC(filename, cvar = "case", pvar = "part", dvar = "zvt", mvar = "day")
res1 <- describe(exampleA1B1A2B2_zvt)$descriptives
res2 <- describe(dat)$descriptives
all.equal(res1,res2)
}
\seealso{
\code{\link{write.table}}, \code{\link{readSC}},
\code{\link{saveRDS}}
}
\author{
Juergen Wilbert
}
\keyword{manip}
