\name{smooth.construct.po.smooth.spec}
%\Rdversion{1.0}
\alias{smooth.construct.po.smooth.spec}
\alias{smooth.construct.ipo.smooth.spec}
\alias{smooth.construct.dpo.smooth.spec}
\alias{smooth.construct.cpop.smooth.spec}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Constructor for SCOP-splines with positivity constraint
}
\description{This is a special method function
  for creating univariate smooths subject to a positivity constraint which is built by 
  the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 
  It is constructed using P-splines. This smooth is specified via model terms such as 
  \code{s(x,k,bs="po",m=2)}, 
  where \code{k} denotes the basis dimension and \code{m+1} is the order of the B-spline basis.
  Increasing and positive SCOP-splines are specified by model terms like \code{s(x,bs="ipo")}.
  Model terms \code{s(x,bs="dpo")} specify decreasing and positive SCOP-splines. Cyclic and positive splines are specified
  by \code{s(x,bs="cpop")}.    

  Note: Models that include positive-valued smooth should not have an intercept. See examples below. 
}
\usage{
\method{smooth.construct}{po.smooth.spec}(object, data, knots)
\method{smooth.construct}{ipo.smooth.spec}(object, data, knots)
\method{smooth.construct}{dpo.smooth.spec}(object, data, knots)
\method{smooth.construct}{cpop.smooth.spec}(object, data, knots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the data required by this term,
     with names given by \code{object$term}. The \code{by} variable is the last element.}
 
  \item{knots}{An optional list containing the knots supplied for basis setup.  
          If it is \code{NULL} then the knot locations are generated automatically.}

}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{ An object of class \code{"po.smooth"}, \code{"ipo.smooth"}, \code{"dpo.smooth"}, \code{"cpop.smooth"} 
}
\references{
Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559

Pya, N. (2010) Additive models with shape constraints. PhD thesis. University of Bath. Department of Mathematical Sciences

}
\author{ 
   Natalya Pya <nat.pya@gmail.com>

}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{smooth.construct.mpd.smooth.spec}},
\code{\link{smooth.construct.cv.smooth.spec}},

\code{\link{smooth.construct.cx.smooth.spec}},
 \code{\link{smooth.construct.mdcv.smooth.spec}}, 

\code{\link{smooth.construct.mdcx.smooth.spec}}, \code{\link{smooth.construct.micv.smooth.spec}}, 

\code{\link{smooth.construct.micx.smooth.spec}}

}
\examples{
 
## example with positivity constraint... 
## simulating data...
\dontrun{
   require(scam)
   set.seed(3)
   n <- 100
   x <- seq(-3,3,length.out=100)
   f <- dnorm(x) 
   y <- f + rnorm(n)*0.1  
   b <- scam(y~s(x,bs="po")-1)
  
   b1 <- scam(y~s(x)) ## unconstrained model
   plot(x,y)
   lines(x,f)
   lines(x,fitted(b),col=2)
   lines(x,fitted(b1),col=3)

  ## two-term example...
  set.seed(3)
  n <- 200
  x1 <- seq(-3,3,length.out=n)
  f1 <- 3*exp(-x1^2) ## positively constrained smooth
  x2 <- runif(n)*3-1;
  f2 <- exp(4*x2)/(1+exp(4*x2)) ## increasing smooth 
  f <- f1+f2
  y <- f+rnorm(n)*0.3
  dat <- data.frame(x1=x1,x2=x2,y=y)
  ## fit model, results, and plot...
  b2 <- scam(y~s(x1,bs="po")+s(x2,bs="mpi")-1,data=dat)
  summary(b2)
  plot(b2,pages=1)

  b3 <- scam(y~s(x1,bs="ps")+s(x2,bs="ps"),data=dat) ## unconstrained model
  summary(b3)
  plot(b3,pages=1) 
  
  ## three-term example: decreasing positive, cyclic positive, piece-wise linear positive...  
  set.seed(3)
  n <- 200
  x1 <- runif(n)*3-1
  f1 <- exp(-1.3*x1)# decreasing positive smooth 
  x2 <-  runif(200)*10
  f2 <- sin(x2*2*pi/10)+1 ## cyclic positive
  x3 <- f3 <- seq(0.34,1.9,length.out=n)  ## for piece-wise linear positive
  ind <- x3 > 1
  f3[!ind] <- 3*x3[!ind] -1 
  f3[ind] <- -2*x3[ind] +4 
  y <- f1+f2+f3 + rnorm(n)*.7
  b <- scam(y ~ s(x1,bs="dpo") +s(x2,bs="cpop",k=7)+ s(x3,bs="po",m=0,k=5) -1 )
  plot(b,pages=1) 
 } 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models} \keyword{regression}%-- one or more ..




