% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCR.ClonotypeComposition.R
\name{TCR.ClonotypeComposition}
\alias{TCR.ClonotypeComposition}
\title{The composition of single-cell TCR clonotypes in the sample}
\usage{
TCR.ClonotypeComposition(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of TCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
The composition of single-cell TCR clonotypes in the sample
}
\examples{

project_data_dir <- "F:/R_Language/data/tcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")
contig_list <- TCR.ContigList(project_data_dir, sample_name, group_name)

BasicPlot(TCR.ClonotypeComposition, contig_list, sample_name)
}
