% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{FilterCCI}
\alias{FilterCCI}
\alias{FilterCCI,scDiffCom-method}
\title{Filter a scDiffCom object with new filtering parameters}
\usage{
FilterCCI(
  object,
  new_threshold_quantile_score = NULL,
  new_threshold_p_value_specificity = NULL,
  new_threshold_p_value_de = NULL,
  new_threshold_logfc = NULL,
  skip_ora = FALSE,
  extra_annotations = NULL,
  verbose = TRUE
)

\S4method{FilterCCI}{scDiffCom}(
  object,
  new_threshold_quantile_score = NULL,
  new_threshold_p_value_specificity = NULL,
  new_threshold_p_value_de = NULL,
  new_threshold_logfc = NULL,
  skip_ora = FALSE,
  extra_annotations = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{scDiffCom} object}

\item{new_threshold_quantile_score}{New threshold value to update
\code{threshold_quantile_score}. If \code{NULL} (default),
the value is not updated.}

\item{new_threshold_p_value_specificity}{New threshold value to update
\code{threshold_p_value_specificity}. If \code{NULL} (default),
the value is not updated.}

\item{new_threshold_p_value_de}{New threshold value to update
\code{threshold_p_value_de}. If \code{NULL} (default),
the value is not updated.}

\item{new_threshold_logfc}{New threshold value to update
\code{threshold_logfc}. If \code{NULL} (default),
the value is not updated.}

\item{skip_ora}{Default is \code{FALSE}. If \code{TRUE}, ORA is not
performed with the new parameters and \code{ora_table} is set to an
empty list. May be useful if one wants to quickly test (loop-over) several
values of parameters and by-passing the ORA computing time.}

\item{extra_annotations}{Convenience parameter to perform ORA on user-defined
non-standard categories. If \code{NULL} (default), ORA is
performed on standard categories. Otherwise it must be a list of data.tables
or data.frames (see Details).}

\item{verbose}{If \code{TRUE} (default) progress messages are printed.}
}
\value{
A scDiffCom object with updated results in \code{cci_table_detected}
and \code{ora_table}.
}
\description{
Filtering (and ORA) is performed with new parameter on an existing
\code{scDiffCom} object. The slots \code{cci_table_detected} and
\code{ora_table} are updated accordingly.
}
\details{
When \code{FilterCCI} is called with new parameters, both
 \code{cci_table_detected} and \code{ora_table} are updated. For
 ORA, a call to \code{RunORA} is automatically performed on all standard
 categories. Additional user-defined ORA categories can be added via the
 parameter \code{extra_annotations}. The data.frames or data.tables in this
 list must have exactly two columns that indicates a relationship between
 values from a standard category (first column) to values of the new
 category (second column). As a typical example, this
 \href{https://cyrillagger.github.io/scDiffCom/articles/scDiffCom-vignette.html}{vignette}
 shows how to perform ORA on cell type families attached to each cell type.
}
