% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.sasfclust}
\alias{plot.sasfclust}
\alias{plot.sasfclust_cv}
\title{Plot the results of  the Sas-funclust method}
\usage{
\method{plot}{sasfclust_cv}(x, ...)

\method{plot}{sasfclust}(x, ...)
}
\arguments{
\item{x}{The output of  either \code{sasfclust} or \code{sasfclust_cv}.}

\item{...}{No additional parameters, called for side effects.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides plots of the estimated cluster mean functions and of the classified curves when applied to the output of \code{sasfclust}, whereas
provides the cross-validation plots when applied to the output of \code{sasfclust_cv}. In the latter case the first plot displays the CV values as a function of  \code{G}, \code{lambda_s} and \code{lambda_l};
the second plot displays the CV values as a function of \code{lambda_s} and \code{lambda_l} for \code{G} fixed at its optimal value;
the third plot displays the CV values as a function of \code{lambda_l} for \code{G} and \code{lambda_s}   fixed at their optimal value.
}
\examples{
\donttest{
library(sasfunclust)
train<-simulate_data("Scenario I",n_i=20,var_e = 1,var_b = 0.5^2)
lambda_s_seq=10^seq(-4,-3)
lambda_l_seq=10^seq(-1,0)
G_seq=2
mod_cv<-sasfclust_cv(X=train$X,grid=train$grid,G_seq=G_seq,
lambda_l_seq = lambda_l_seq,lambda_s_seq =lambda_s_seq,maxit = 20,K_fold = 2,q=10)
plot(mod_cv)
mod<-sasfclust(X=train$X,grid=train$grid,lambda_s = 10^-6,lambda_l =10,G = 2,maxit = 20,q=10)
plot(mod)
}
}
