% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl.R
\name{pomdpsol}
\alias{pomdpsol}
\alias{appl}
\alias{SARSOP}
\alias{polgraph}
\alias{pomdpsim}
\alias{pomdpeval}
\alias{pomdpconvert}
\title{APPL wrappers}
\usage{
pomdpsol(
  model,
  output = tempfile(),
  precision = 0.001,
  timeout = NULL,
  fast = FALSE,
  randomization = FALSE,
  memory = NULL,
  improvementConstant = NULL,
  timeInterval = NULL,
  stdout = tempfile(),
  stderr = tempfile(),
  spinner = TRUE
)

polgraph(
  model,
  policy,
  output = tempfile(),
  max_depth = 3,
  max_branches = 10,
  min_prob = 0.001,
  stdout = "",
  spinner = TRUE
)

pomdpsim(
  model,
  policy,
  output = tempfile(),
  steps = 100,
  simulations = 3,
  stdout = "",
  spinner = TRUE
)

pomdpeval(
  model,
  policy,
  output = tempfile(),
  steps = 100,
  simulations = 3,
  stdout = "",
  spinner = TRUE
)

pomdpconvert(model, stdout = "", spinner = TRUE)
}
\arguments{
\item{model}{file/path to the \code{pomdp} model file}

\item{output}{file/path of the output policy file. This is also returned
by the function.}

\item{precision}{targetPrecision. Set targetPrecision as the target precision
in solution quality; run ends when target precision is reached. The target
 precision is 1e-3 by default.}

\item{timeout}{Use timeLimit as the timeout in seconds.  If running time
exceeds the specified value, pomdpsol writes out a policy and terminates.
There is no time limit by default.}

\item{fast}{logical, default FALSE. use fast (but very picky) alternate
parser for .pomdp files.}

\item{randomization}{logical, default FALSE. Turn on randomization for the
sampling algorithm.}

\item{memory}{Use memoryLimit as the memory limit in MB. No memory limit
by default.  If memory usage exceeds the specified value, pomdpsol writes
out a policy and terminates. Set the value to be less than physical memory
to avoid swapping.}

\item{improvementConstant}{Use improvementConstant as the trial improvement
factor in the sampling algorithm. At the default of 0.5, a trial terminates
at a belief when the gap between its upper and lower bound is 0.5 of the
current precision at the initial belief.}

\item{timeInterval}{Use timeInterval as the time interval between two
consecutive write-out of policy files. If this is not specified, pomdpsol
only writes out a policy file upon termination.}

\item{stdout}{a filename where pomdp run statistics will be stored}

\item{stderr}{currently ignored.}

\item{spinner}{should we show a spinner while sarsop is running?}

\item{policy}{file/path to the policy file}

\item{max_depth}{the maximum horizon of the generated policy graph}

\item{max_branches}{maximum number of branches to show in the policy graph}

\item{min_prob}{the minimum probability threshold for a branch to be shown in the policy graph}

\item{steps}{number of steps for each simulation run}

\item{simulations}{as the number of simulation runs}
}
\description{
Wrappers for the APPL executables. The \code{pomdpsol} function solves a model
file and returns the path to the output policy file.
}
\examples{
\donttest{

if(assert_has_appl()){
  model <- system.file("models", "example.pomdp", package = "sarsop")
  policy <- tempfile(fileext = ".policyx")
  pomdpsol(model, output = policy, timeout = 1)

# Other tools
  evaluation <- pomdpeval(model, policy, stdout = FALSE)
  graph <- polgraph(model, policy, stdout = FALSE)
  simulations <- pomdpsim(model, policy, stdout = FALSE)
}

}
}
