% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.snowprofileSet.R
\name{summary.snowprofileSet}
\alias{summary.snowprofileSet}
\title{Summarize multiple snowprofiles}
\usage{
\method{summary}{snowprofileSet}(object, ...)
}
\arguments{
\item{object}{list of snowprofile objects}

\item{...}{additional arguments for generic method}
}
\value{
data.frame
}
\description{
Wrapper for \link{summary.snowprofile}, which only returns metadata for a single snowprofile object. summary.snowprofileSet provides metadata for multiple snowprofiles, which is useful for subsetting.
}
\examples{

## Extract metadata for a group of profiles
Metadata <- summary(SPgroup)
head(Metadata)

## Subsetting profiles with Metadata
Alpine <- SPgroup[Metadata$elev > 2000]
summary(Alpine)
Shallow <- SPgroup[Metadata$hs < 150]
summary(Shallow)
Week2 <- SPtimeline[summary(SPtimeline)$date > '2017-12-15']

}
\seealso{
\link{summary.snowprofile}, \link{rbind.snowprofileSet}
}
\author{
shorton
}
