% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtwSP.R
\name{dtwSP}
\alias{dtwSP}
\title{Calculate DTW alignment of two snow profiles}
\usage{
dtwSP(
  query,
  ref,
  open.end = TRUE,
  checkGlobalAlignment = TRUE,
  keep.internals = TRUE,
  step.pattern = symmetricP1,
  resamplingRate = 0.5,
  rescale2refHS = TRUE,
  bottom.up = TRUE,
  top.down = TRUE,
  ...
)
}
\arguments{
\item{query}{The query snow profile to be warped}

\item{ref}{The reference snow profile to be warped against}

\item{open.end}{Is an open end alignment desired?}

\item{checkGlobalAlignment}{If \code{open.end = TRUE}, do you want to check whether a global alignment performs better (i.e.,
\code{open.end = FALSE}), and use the optimal one of the computed alignments?}

\item{keep.internals}{Append resampled and aligned snow profiles as well as internal parameters to the output object?}

\item{step.pattern}{The local slope constraint of the warping path, defaults to Sakoe-Chiba's symmetric pattern
described by a slope factor of P = 1, see \link[dtw:stepPattern]{dtw::stepPattern}}

\item{resamplingRate}{Resampling rate for a regular depth grid; can also be a vector that provides the depth grid.
Set to \code{NA} to keep the (original, likely irregular) depth grid (see Details, bullet point 2.2).}

\item{rescale2refHS}{Rescale the query snow height to match the ref snow height?}

\item{bottom.up}{Compute an open.end alignment from the ground upwards?}

\item{top.down}{Compute an open.end alignment from the snow surface downwards?}

\item{...}{Arguments passed to \code{\link{distMatSP}} and \code{\link{dtw}}, e.g.
\itemize{
\item \code{dims}, \code{weights} (defaults specified in \code{\link{distMatSP}})
\item \code{ddateNorm}, numeric, normalize deposition date (default specified in \code{\link{distMatSP}})
\item \code{windowFunction}, default \code{\link{warpWindowSP}}
\item \code{window.size}, \code{ddate.window.size} (defaults specified in \code{\link{warpWindowSP}})
\item \code{gtype_distMat}, (default specified in \code{\link{distMatSP}}), cf. e.g. \link{grainSimilarity_align}
\item \code{prefLayerWeights}, weighting matrix for preferential layer matching, e.g. \link{layerWeightingMat}
}}
}
\value{
An alignment object of class 'dtwSP' is returned. This is essentially a list with various information about the alignment.
If \code{keep.internals = TRUE}, the resampled snow profiles 'query', 'reference' and 'queryWarped', as well as the
'costMatrix' and 'directionMatrix' are elements of the returned object.
}
\description{
This is the core function of the package and allows to match layers between pairs of snow profiles to align them. It
provides a variety of options, where the default values represent a good starting point to the alignment of most generic
profiles.
}
\details{
The individual steps of aligning snow profiles:
\enumerate{
\item (optional) \strong{Rescale} the profiles to the same height (cf., \link{scaleSnowHeight})
\item \strong{Resample} the profiles onto the same depth grid. 2 different approaches:
\itemize{
\item regular grid with a sampling rate that is provided by the user (recommended, cf., \link{resampleSP}).
This approach requires to rescale the profiles.
\item irregular grid that includes all layer interfaces within the two profiles (i.e., set \code{resamplingRate = NA}) (cf., \link{resampleSPpairs})
}
\item Compute a weighted \strong{local cost matrix} from multiple layer characteristics (cf., \link{distMatSP})
\item \strong{Match the layers} of the profiles with a call to \link{dtw} (eponymous R package)
\item Align the profiles by \strong{warping} the query profile onto the reference profile (cf., \link{warpSP})
\item (optional) If the function has been called with multiple different boundary conditions (global, top-down, or bottom-up alignments),
the optimal alignment as determined by \link{simSP} will be returned.
}
}
\note{
While DTW can be applied to sequences of different lengths, it is necessary that the two snow profiles have the same
number of layers for optimally warping one profile onto the other one and thereby aligning them. As long as the profiles
are rescaled and resampled this requirement is satisfied. This requirement is inconvenient only if the profiles
are not supposed to be rescaled (e.g. in a layer tracking application). In these cases, a workaround is to rescale the
profiles anyway, but increase the window size of the warping window proportionally to the snow height offset. In these cases
also consider including layer date information to reduce the likelihood of bad alignments.

Furthermore, the alignment based on grain type information is currently only possible for specific grain types. These grain types
require a pre-defined distance or similarity, such as given by \link{grainSimilarity_align}. If your profile contains other grain types,
you are required to define your custom \code{grainSimilarity} matrix.
}
\examples{

dtwAlignment <- dtwSP(SPpairs$A_modeled, SPpairs$A_manual, open.end = FALSE)

## dtwSP object:
summary(dtwAlignment)
plot(dtwAlignment$queryWarped)
plotSPalignment(dtwAlignment = dtwAlignment)

}
\seealso{
\link{plotSPalignment}, \link{simSP}
}
\author{
fherla
}
