% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodogram.R
\name{periodogram}
\alias{periodogram}
\title{Obtain the most important period lags of a time series according to 
    a periodogram.}
\usage{
periodogram(x, ..., no.results = 20)
}
\arguments{
\item{x}{A vector containing the time series values}

\item{...}{Arguments to be passed to \code{spectrum}}

\item{no.results}{The number of results to be printed at the end. Defaults to 
the 20 most important frequencies.}
}
\value{
A data.frame containing the following columns:
    \item{rank}{numeric vector containing the ranked importance of the 
        frequency.}
    \item{spectrum}{estimates of the spectral density at frequencies 
        corresponding to \code{freq}.}
    \item{frequency}{vector at which the spectral density is estimated.}
    \item{period}{vector of corresponding periods.}
}
\description{
Obtain the most important period lags of a time series according to 
    a periodogram.
}
\details{
Using the \code{spectral} function, obtain spectral density estimates at a 
    number of frequencies and rather than plotting, obtain the rank and 
    period of the values. Return a given number of results based on the level
    of interest of the user.
}
