% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_saq_observations.R
\name{get_saq_observations}
\alias{get_saq_observations}
\title{Function to get \strong{saqgetr} air quality observations.}
\usage{
get_saq_observations(
  site,
  variable = NA,
  start = NA,
  end = NA,
  valid_only = FALSE,
  tz = "UTC",
  verbose = FALSE
)
}
\arguments{
\item{site}{A vector of sites to import. Use \link{get_saq_sites} to find
what sites are available.}

\item{variable}{An optional variable vector. If not used, all variables will
be returned.}

\item{start}{Start date for returned observations. Can either be a date string in
\code{"yyyy-mm-dd"} format, or a year integer.}

\item{end}{End date for returned observations. Can either be a date string in
\code{"yyyy-mm-dd"} format, or a year integer.}

\item{valid_only}{Should only valid observations be kept?}

\item{tz}{Time zone for the observations' dates.}

\item{verbose}{Should the function give messages?}
}
\value{
Tibble.
}
\description{
Function to get \strong{saqgetr} air quality observations.
}
\examples{

# Load a site's data
data_hafodyrynys <- get_saq_observations(
  site = "gb1038a", 
  start = 2018, 
  end = 2018
)

# Print tibble
data_hafodyrynys

\donttest{

# Get multiple sites nox and ozone data for between a date range
data_many <- get_saq_observations(
  site = c("gb1014a", "gb1044a", "gb1060a"),
  variable = c("nox", "no2", "o3"),
  start = 2018,
  end = 2019,
  verbose = TRUE
)

# Print tibble
data_many

# Sites and site names
data_many \%>\% 
  dplyr::distinct(site)
  
}

}
\seealso{
\code{\link{get_saq_sites}}, \code{\link{saq_clean_observations}}
}
\author{
Stuart K. Grange.
}
