% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectMHMMR.R
\name{selectMHMMR}
\alias{selectMHMMR}
\title{selectMHMMR implements a model selection procedure to select an optimal MHMMR
model with unknown structure.}
\usage{
selectMHMMR(X, Y, Kmin = 1, Kmax = 10, pmin = 0, pmax = 4,
  criterion = c("BIC", "AIC"), verbose = TRUE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Matrix of size \eqn{(m, d)} representing a \eqn{d} dimension time
series observed at points \eqn{1,\dots,m}.}

\item{Kmin}{The minimum number of regimes (c components).}

\item{Kmax}{The maximum number of regimes (MHMMR components).}

\item{pmin}{The minimum order of the polynomial regression.}

\item{pmax}{The maximum order of the polynomial regression.}

\item{criterion}{The criterion used to select the MHMMR model ("BIC", "AIC").}

\item{verbose}{Optional. A logical value indicating whether or not a summary
of the selected model should be displayed.}
}
\value{
selectMHMMR returns an object of class \link{ModelMHMMR}
representing the selected MHMMR model according to the chosen \code{criterion}.
}
\description{
selectMHMMR implements a model selection procedure to select an optimal MHMMR
model with unknown structure.
}
\details{
selectMHMMR selects the optimal MHMMR model among a set of model
candidates by optimizing a model selection criteria, including the Bayesian
Information Criterion (BIC). This function first fits the different MHMMR
model candidates by varying the number of regimes \code{K} from \code{Kmin} to \code{Kmax}
and the order of the polynomial regression \code{p} from \code{pmin} to \code{pmax}. The
model having the highest value of the chosen selection criterion is then
selected.
}
\examples{
data(multivtoydataset)
x <- multivtoydataset$x
y <- multivtoydataset[, c("y1", "y2", "y3")]

selectedmhmmr <- selectMHMMR(X = x, Y = y, Kmin = 2, Kmax = 6,
                             pmin = 0, pmax = 2)

selectedmhmmr$summary()
}
\seealso{
\link{ModelMHMMR}
}
