# testthat sources files beginning with helper- before running unit tests.
# This helper file contains data for each of the unit tests so that it is not
# repeated across test files.

baselist <- list(
  res = matrix(c(1,  1,  2,  2,  3,  3,  2,  2,  1,  1,
                  1,  2,  2,  3, 10, 10,  3,  2,  2,  1,
                  1,  2,  2,  3, 10, 10,  3,  2,  2,  1,
                  1,  1,  1,  3, 10, 10,  3,  1,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  1, 10, 10, 10, 10, 10, 10,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                nrow = 10),
  abs = matrix(c(1,  2,  1,  1,  1,  1,  1,  1,  1,  4,
                  1,  1,  1,  2,  2,  1,  1,  0,  1,  5,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                  1,  5,  1,  1,  1,  1,  1,  0,  0,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,
                  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,
                  1,  1,  1,  2,  1,  1,  1,  7,  7,  1,
                  1,  1,  1,  1,  1,  1,  1,  7,  7,  1,
                  3,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                nrow = 10) / 1000,
  fid = matrix(c(10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                  10, 10, 10, 10,  1,  1, 10, 10, 10, 10,
                  10, 10, 10, 10,  1,  1, 10, 10, 10, 10,
                  10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                  10, 10, 10, 10, 10, 10, 50, 50, 50, 10,
                  10, 10, 10, 10, 10, 10, 50, 50, 50, 10,
                  10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                  10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                  10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                  10, 10, 10, 10, 10, 10, 10, 10, 10, 10),
                nrow = 10) / 100,
  occ = matrix(c(0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,
                  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,
                  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,
                  0,  1,  1,  0,  0,  0,  0,  0,  0,  0,
                  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
                  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
                nrow = 10)
)


# Raster masks for testing different scenarios
masklist <- list(
  mask1 = matrix(c(1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                  nrow = 10),
  mask2 = matrix(c(1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1, NA, NA, NA, NA,  1,  1,  1,
                    1,  1,  1, NA, NA, NA, NA,  1,  1,  1,
                    1,  1,  1, NA, NA, NA, NA,  1,  1,  1,
                    1,  1,  1, NA, NA, NA, NA,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                  nrow = 10),
  mask3 = matrix(c(1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                  nrow = 10),
  mask4 = matrix(c(1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1, NA, NA, NA,  1,  1,  1,
                    1,  1,  1,  1, NA,  1, NA,  1,  1,  1,
                    1,  1,  1,  1, NA, NA, NA,  1,  1,  1,
                    1, NA, NA, NA,  1,  1,  1,  1,  1,  1,
                    1, NA,  1, NA,  1,  1,  1,  1,  1,  1,
                    1, NA, NA, NA,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
                    1,  1,  1,  1,  1,  1,  1,  1,  1,  1),
                  nrow = 10)
)

testlist <- list()
for(i in 1: length(masklist)) {
  testlist[[i]] <- lapply(baselist, function(x) {masklist[[i]] * x})

  testlist[[i]]$length <- sum(!is.na(testlist[[i]]$res))

  testlist[[i]]$samc <- samc(testlist[[i]]$res, testlist[[i]]$abs, testlist[[i]]$fid, tr_fun = function(x) 1/mean(x), override = TRUE)

  testlist[[i]]$id <- i
}


time = 100
time_vec = c(3, 5, 7, 11, 13)
row_vec = c(7, 34, 5, 5)
col_vec = c(13, 13, 5, 19)
