% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_run_bulk_operation}
\alias{sf_run_bulk_operation}
\alias{sf_bulk_operation}
\title{Run Bulk Operation}
\usage{
sf_run_bulk_operation(
  input_data,
  object_name,
  operation = c("insert", "delete", "upsert", "update", "hardDelete"),
  external_id_fieldname = NULL,
  guess_types = TRUE,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  batch_size = NULL,
  interval_seconds = 3,
  max_attempts = 200,
  wait_for_results = TRUE,
  record_types = c("successfulResults", "failedResults", "unprocessedRecords"),
  combine_record_types = TRUE,
  control = list(...),
  ...,
  verbose = FALSE
)

sf_bulk_operation(
  input_data,
  object_name,
  operation = c("insert", "delete", "upsert", "update", "hardDelete"),
  external_id_fieldname = NULL,
  guess_types = TRUE,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  batch_size = NULL,
  interval_seconds = 3,
  max_attempts = 200,
  wait_for_results = TRUE,
  record_types = c("successfulResults", "failedResults", "unprocessedRecords"),
  combine_record_types = TRUE,
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; data can be coerced into CSV file for submitting as batch request}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{operation}{\code{character}; string defining the type of operation being performed}

\item{external_id_fieldname}{\code{character}; string identifying a custom field on the
object that has been set as an "External ID" field. This field is used to reference
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used, if \code{FALSE} then all fields will be returned
as character. This is helpful when \code{col_guess()} will mangle field values
in Salesforce that you'd like to preserve during translation into a \code{tbl_df},
like numeric looking values that must be preserved as strings ("48.0").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{batch_size}{\code{integer}; the number of individual records to be included in a
single batch uploaded to the Bulk APIs (1.0 or 2.0).}

\item{interval_seconds}{\code{integer}; defines the seconds between attempts to check
for job completion.}

\item{max_attempts}{\code{integer}; defines then max number attempts to check for job
completion before stopping.}

\item{wait_for_results}{\code{logical}; indicating whether to wait for the operation to complete
so that the batch results of individual records can be obtained}

\item{record_types}{\code{character}; one or more types of records to retrieve
from the results of running the specified job}

\item{combine_record_types}{\code{logical}; indicating for Bulk 2.0 jobs whether the
successfulResults, failedResults, and unprocessedRecords should be stacked
together by binding the rows}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{other arguments passed on to \code{\link{sf_control}} or \code{\link{sf_create_job_bulk}}
to specify the \code{content_type}, \code{concurrency_mode}, and/or \code{column_delimiter}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} of the results of the bulk job
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function is a convenience wrapper for submitting bulk API jobs
}
\note{
With Bulk 2.0 the order of records in the response is not guaranteed to
match the ordering of records in the original job data.
}
\examples{
\dontrun{
n <- 20
new_contacts <- tibble(FirstName = rep("Test", n), 
                       LastName = paste0("Contact", 1:n))
# insert new records into the Contact object
inserts <- sf_bulk_operation(input_data = new_contacts, 
                             object_name = "Contact", 
                             operation = "insert")
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}{Salesforce Documentation}
}
