% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_delete_report_instance}
\alias{sf_delete_report_instance}
\title{Delete a report instance}
\usage{
sf_delete_report_instance(report_id, report_instance_id, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{report_instance_id}{\code{character}; the Salesforce Id assigned to a
created analytics report instance (an asynchronous run). It will start with
\code{"0LG"}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{logical} indicating whether the report instance was deleted. This function
will return \code{TRUE} if successful in deleting the report instance.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

If the given report instance has a status of \code{Success} or \code{Error},
delete the report instance.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_instance_resource_results.htm}{Documentation}
}
}

\examples{
\dontrun{
# first, get the Id of a report in your Org
all_reports <- sf_query("SELECT Id, Name FROM Report")
this_report_id <- all_reports$Id[1]

# second, ensure that report has been executed at least once asynchronously
results <- sf_execute_report(this_report_id, async=TRUE)

# check if that report has succeeded, if so (or if it errored), then delete
instance_list <- sf_list_report_instances(this_report_id)
instance_status <- instance_list[[which(instance_list$id == results$id), "status"]]
}
}
\seealso{
Other Report Instance functions: 
\code{\link{sf_get_report_instance_results}()},
\code{\link{sf_list_report_instances}()}
}
\concept{Report Instance functions}
