% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-matrix-diag.r
\name{diag}
\alias{diag}
\alias{diag.dual}
\alias{diag,dual-method}
\alias{diag<-,dual,dual-method}
\alias{diag<-,dual,numericOrArray-method}
\title{Matrix diagonals}
\usage{
diag.dual(x, nrow, ncol, names = TRUE)

\S4method{diag}{dual}(x = 1, nrow, ncol, names = TRUE)

\S4method{diag}{dual,dual}(x) <- value

\S4method{diag}{dual,numericOrArray}(x) <- value
}
\arguments{
\item{x}{a dual object}

\item{nrow, ncol}{(optional) dimensions of result}

\item{names}{if 'TRUE', pass names along}

\item{value}{replacement value}
}
\value{
A dual object, similarly to `base::diag`
}
\description{
Methods extending to dual objects the corresponding methods for numeric objects.
}
\examples{
x <- dual( c(1,2) )
diag(x)
d(diag(x), "x1")
y <- matrix(x, 2, 2)
diag(y) <- 2*diag(y)
y
d(y)
diag(y)
}
