% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{gendata}
\alias{gendata}
\title{Simulation Scenario from Bhatnagar et al. (2018+) sail paper}
\usage{
gendata(n, p, corr, E = truncnorm::rtruncnorm(n, a = -1, b = 1), betaE,
  SNR, parameterIndex)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of main effect variables (X)}

\item{corr}{correlation between predictors}

\item{E}{simulated environment vector of length \code{n}. Can be continuous
or integer valued. Factors must be converted to numeric. Default:
\code{truncnorm::rtruncnorm(n, a = -1, b = 1)}}

\item{betaE}{exposure effect size}

\item{SNR}{signal to noise ratio}

\item{parameterIndex}{simulation scenario index. See details for more
information.}
}
\value{
A list with the following elements: \describe{ \item{x}{matrix of
  dimension \code{nxp} of simulated main effects} \item{y}{simulated response
  vector of length \code{n}} \item{e}{simulated exposure vector of length
  \code{n}} \item{Y.star}{linear predictor vector of length \code{n}}
  \item{f1}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f2}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f3}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{f4}{the function \code{f1} evaluated at \code{x_1} (\code{f1(X1)})}
  \item{betaE}{the value for \eqn{\beta_E}} \item{f1.f}{the function
  \code{f1}} \item{f2.f}{the function \code{f2}} \item{f3.f}{the function
  \code{f3}} \item{f4.f}{the function \code{f4}} \item{X1}{an \code{n} length
  vector of the first predictor} \item{X2}{an \code{n} length vector of the
  second predictor} \item{X3}{an \code{n} length vector of the third
  predictor} \item{X4}{an \code{n} length vector of the fourth predictor}
  \item{scenario}{a character representing the simulation scenario identifier
  as described in Bhatnagar et al. (2018+)}\item{causal}{character vector of
  causal variable names}\item{not_causal}{character vector of noise
  variables} }
}
\description{
Function that generates data of the different simulation studies
  presented in the accompanying paper. This function requires the
  \code{truncnorm} package to be installed.
}
\details{
We evaluate the performance of our method on three of its defining
  characteristics: 1) the strong heredity property, 2) non-linearity of
  predictor effects and 3) interactions. \describe{ \item{Heredity
  Property}{\describe{\item{}{Truth obeys strong hierarchy
  (\code{parameterIndex = 1}) \deqn{Y* = \sum_{j=1}^{4} f_j(X_{j}) + \beta_E
  * X_{E} +  X_{E} * f_3(X_{3}) + X_{E} * f_4(X_{4}) }} \item{}{Truth obeys
  weak hierarchy (\code{parameterIndex = 2}) \deqn{Y* = f_1(X_{1}) +
  f_2(X_{2}) + \beta_E * X_{E} +  X_{E} * f_3(X_{3}) + X_{E} * f_4(X_{4}) }}
  \item{}{Truth only has interactions (\code{parameterIndex = 3})\deqn{Y* =
  X_{E} * f_3(X_{3}) + X_{E} * f_4(X_{4}) }}}} \item{Non-linearity}{Truth is
  linear (\code{parameterIndex = 4}) \deqn{Y* = \sum_{j=1}^{4}\beta_j X_{j} +
  \beta_E * X_{E} +  X_{E} * X_{3} + X_{E} * X_{4} }}
  \item{Interactions}{Truth only has main effects (\code{parameterIndex = 5})
  \deqn{Y* = \sum_{j=1}^{4} f_j(X_{j}) + \beta_E * X_{E} }} }.

  The functions are from the paper by Lin and Zhang (2006):
  \describe{\item{f1}{f1 <- function(t) 5 * t} \item{f2}{  f2 <- function(t)
  3 * (2 * t - 1)^2} \item{f3}{  f3 <- function(t) 4 * sin(2 * pi * t) / (2 -
  sin(2 * pi * t))} \item{f4}{  f4 <- function(t) 6 * (0.1 * sin(2 * pi * t)
  + 0.2 * cos(2 * pi * t) + 0.3 * sin(2 * pi * t)^2 + 0.4 * cos(2 * pi * t)^3
  + 0.5 * sin(2 * pi * t)^3)}}


  The response is generated as \deqn{Y = Y* + k*error} where Y* is the linear
  predictor, the error term is generated from a standard normal distribution,
  and k is chosen such that the signal-to-noise ratio is SNR =
  Var(Y*)/Var(error), i.e., the variance of the response variable Y due to
  error is 1/SNR of the variance of Y due to Y*

  The covariates are simulated as follows as described in Huang et al.
  (2010). First, we generate \eqn{w1,\ldots, wp, u,v} independently from
  \eqn{Normal(0,1)} truncated to the interval \code{[0,1]} for
  \eqn{i=1,\ldots,n}. Then we set \eqn{x_j = (w_j + t*u)/(1 + t)} for \eqn{j
  = 1,\ldots, 4} and \eqn{x_j = (w_j + t*v)/(1 + t)} for \eqn{j = 5,\ldots,
  p}, where the parameter \eqn{t} controls the amount of correlation among
  predictors. This leads to a compound symmetry correlation structure where
  \eqn{Corr(x_j,x_k) = t^2/(1+t^2)}, for \eqn{1 \le j \le 4, 1 \le k \le 4},
  and \eqn{Corr(x_j,x_k) = t^2/(1+t^2)}, for \eqn{5 \le j \le p, 5 \le k \le
  p}, but the covariates of the nonzero and zero components are independent.
}
\examples{
DT <- gendata(n = 75, p = 100, corr = 0, betaE = 2, SNR = 1, parameterIndex = 1)
}
\references{
Lin, Y., & Zhang, H. H. (2006). Component selection and smoothing
  in multivariate nonparametric regression. The Annals of Statistics, 34(5),
  2272-2297.

Huang J, Horowitz JL, Wei F. Variable selection in nonparametric
  additive models (2010). Annals of statistics. Aug 1;38(4):2282.

Bhatnagar SR, Yang Y, Greenwood CMT. Sparse additive interaction
  models with the strong heredity property (2018+). Preprint.
}
