% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkColumn.R
\name{checkColumn}
\alias{checkColumn}
\title{Check that a setting parameter has a matching data column}
\usage{
checkColumn(key, settings, data)
}
\arguments{
\item{key}{a list (like those provided by \code{getSettingKeys())} defining the position of parameter in the settings object.}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}

\item{data}{A data frame to check for the specified column}
}
\value{
A list containing the results of the check following the format specified in \code{validateSettings()[["checkList"]]}
}
\description{
Checks that a single parameter from the settings list matches a column name in a specified data set
}
\details{
This function compares settings with column names as part of the \code{validateSettings()} function. More specifically, the function checks whether the \code{key} in a \code{settings} object matches a column in  \code{"data"}.
}
\examples{
testSettings<-generateSettings(standard="AdAM")
testSettings$filters<-list()
testSettings$filters[[1]]<-list(value_col="RACE",label="Race")
testSettings$filters[[2]]<-list(value_col=NULL,label="No Column")
testSettings$filters[[3]]<-list(value_col="NotAColumn",label="Invalid Column")

#pass ($valid == TRUE)
safetyGraphics:::checkColumn(key=list("id_col"),
                                    settings=testSettings, adlbc)

#pass
safetyGraphics:::checkColumn(key=list("filters",1,"value_col"),
                                    settings=testSettings, adlbc)

#NULL column pass
safetyGraphics:::checkColumn(key=list("filters",2,"value_col"),
                                    settings=testSettings, adlbc)

#invalid column fails
safetyGraphics:::checkColumn(key=list("filters",3,"value_col"),
                                    settings=testSettings, adlbc)
}
\keyword{internal}
