\name{check_conf_int-internal}
\alias{check_conf_int}
\title{Checks for parameters to compute the confidence intervals for the AUC}
\description{Check of the consistency of the parameters indicated to compute the confidence intervals for the AUC.}
\usage{check_conf_int(conf.int, ci.cl, ci.meth, ci.nboots, parallel, ncpus)}
\arguments{
  \item{conf.int}{parameter indicating whether confidence intervals for the AUC will be computed (\strong{``T''}) or not  (\strong{``F''}). The default is ``F''.}
  \item{ci.cl}{confidence level at which the confidence intervals for the AUC will be calculated. The default value is 0.95.}
  \item{ci.meth}{method for computing the confidence intervals according to \doi{10.1515/ijb-2019-0097}. There are three options:
  \itemize{
  \item \bold{``E''}, for the \bold{E}mpirical variance estimation.
  \item \bold{``V''}, for the theoretical \bold{V}ariance estimation.
  \item \bold{``B''}, for the \bold{B}ootstrap Percentile.
   }
The empirical method \bold{E} is taken as default. This parameter is ignored if \code{conf.int} is set to ``F''.
}

  \item{ci.nboots}{number of bootstrap samples to be generated when the chosen \code{ci.meth} is \strong{``B''.} The default values is 500.}
  \item{parallel}{indicates whether parallel computing will be done (\bold{``T''}) or not (\bold{``F''}), when computing the variance of the AUC through the methods \strong{``V''} and \strong{``B''}.}
\item{ncpus}{number of CPUS that will be used when parallel computing is chosen.}
}

\value{A list with the following components:
\item{ci.cl}{value entered as confidence level for the AUC.}
\item{ci.meth}{value entered as method for computing the confidence intervals.}
\item{ci.nboots}{value entered as number of bootstrap samples.}
\item{ci.ncpus}{value entered as number of CPUs chosen.}
\item{message}{table with the warning messages generated by the function.}
}
