% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{delete}
\alias{delete}
\alias{s3_file_delete}
\alias{s3_dir_delete}
\title{Delete files and directories}
\usage{
s3_file_delete(path, ...)

s3_dir_delete(path)
}
\arguments{
\item{path}{(character): A character vector of paths or s3 uris.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_delete_objects}}}
}
\value{
character vector of s3 uri paths
}
\description{
\code{s3_file_delete} delete files in AWS S3

\code{s3_dir_delete} delete directories in AWS S3 recursively.
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = s3_file_temp(tmp_dir= "MyBucket")
s3_file_create(temp_file)

s3_file_delete(temp_file)
}
}
