% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomWalkTest.R
\name{RandomWalkTest}
\alias{RandomWalkTest}
\title{Random walk test for skill differences}
\usage{
RandomWalkTest(skill_A, skill_B, time_dim = "sdate", ncores = NULL)
}
\arguments{
\item{skill_A}{A numerical array of the time series of the skill with the 
forecaster A's.}

\item{skill_B}{A numerical array of the time series of the skill with the 
forecaster B's. The dimensions should be identical as parameter 'skill_A'.}

\item{time_dim}{A character string indicating the name of the dimension along
which the tests are computed. The default value is 'sdate'.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of 2:
\item{$score}{
 A numerical array with the same dimensions as the input arrays except 
 'time_dim'. The number of times that forecaster A has been better than 
 forecaster B minus the number of times that forecaster B has been better 
 than forecaster A (for skill positively oriented). If $score is positive 
 forecaster A is better than forecaster B, and if $score is negative 
 forecaster B is better than forecaster B.
}
\item{$signif}{
 A logical array with the same dimensions as the input arrays except 
 'time_dim'. Whether the difference is significant or not at the 5% 
 significance level.
}
}
\description{
Forecast comparison of the skill obtained with 2 forecasts (with respect to a 
common reference) based on Random Walks, with significance estimate at the 95%
confidence level, as in DelSole and Tippett (2016).
}
\examples{
fcst_A <- array(c(11:50), dim = c(sdate = 10, lat = 2, lon = 2))
fcst_B <- array(c(21:60), dim = c(sdate = 10, lat = 2, lon = 2))
reference <- array(1:40, dim = c(sdate = 10, lat = 2, lon = 2))
skill_A <- abs(fcst_A - reference)
skill_B <- abs(fcst_B - reference)
RandomWalkTest(skill_A = skill_A, skill_B = skill_B, time_dim = 'sdate', ncores = 1)

}
