% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{s2_plot}
\alias{s2_plot}
\title{Plot S2 Geographies}
\usage{
s2_plot(
  x,
  ...,
  asp = 1,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE,
  plot_hemisphere = FALSE,
  simplify = TRUE,
  centre = NULL
)
}
\arguments{
\item{x}{A \code{\link[wk:wkb]{wkb()}} or \code{\link[wk:wkt]{wkt()}}}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{asp}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{xlab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{rule}{The rule to use for filling polygons (see \code{\link[graphics:polypath]{graphics::polypath()}})}

\item{add}{Should a new plot be created, or should \code{handleable} be added to the
existing plot?}

\item{plot_hemisphere}{Plot the outline of the earth}

\item{simplify}{Use \code{FALSE} to skip the simplification step}

\item{centre}{The longitude/latitude point of the centre of the
orthographic projection}
}
\value{
The input, invisibly
}
\description{
Plot S2 Geographies
}
\examples{
s2_plot(s2_data_countries())
s2_plot(s2_data_cities(), add = TRUE)

}
