% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-geography.R
\name{as_s2_geography}
\alias{as_s2_geography}
\alias{as_s2_geography.default}
\alias{as_s2_geography.s2_geography}
\alias{as_s2_geography.s2_latlng}
\alias{as_s2_geography.s2_point}
\alias{as_s2_geography.wk_wkb}
\alias{as_s2_geography.WKB}
\alias{as_s2_geography.blob}
\alias{as_s2_geography.wk_wkt}
\alias{as_s2_geography.character}
\alias{as_s2_geography.logical}
\alias{as_wkb.s2_geography}
\alias{as_wkt.s2_geography}
\title{Create an S2 Geography Vector}
\usage{
as_s2_geography(x, ...)

\method{as_s2_geography}{default}(x, ...)

\method{as_s2_geography}{s2_geography}(x, ...)

\method{as_s2_geography}{s2_latlng}(x, ...)

\method{as_s2_geography}{s2_point}(x, ...)

\method{as_s2_geography}{wk_wkb}(x, ..., oriented = FALSE, check = TRUE)

\method{as_s2_geography}{WKB}(x, ..., oriented = FALSE, check = TRUE)

\method{as_s2_geography}{blob}(x, ..., oriented = FALSE, check = TRUE)

\method{as_s2_geography}{wk_wkt}(x, ..., oriented = FALSE, check = TRUE)

\method{as_s2_geography}{character}(x, ..., oriented = FALSE, check = TRUE)

\method{as_s2_geography}{logical}(x, ...)

\method{as_wkb}{s2_geography}(x, ..., endian = wk::wk_platform_endian())

\method{as_wkt}{s2_geography}(x, ..., precision = 16, trim = TRUE)
}
\arguments{
\item{x}{An object that can be converted to an s2_geography vector}

\item{...}{Unused}

\item{oriented}{TRUE if polygon ring directions are known to be correct
(i.e., exterior rings are defined counter clockwise and interior
rings are defined clockwise).}

\item{check}{Use \code{check = FALSE} to error on invalid geometries}

\item{endian}{The endian to use when writing well-known binary.
Defaults to the platform endian. See \code{\link[wk:wkb]{wk::as_wkb()}}.}

\item{precision}{The number of significant digits to export when
writing well-known text. If \code{trim = FALSE}, the number of
digits after the decimal place.}

\item{trim}{Should trailing zeroes be included after the decimal place?}
}
\value{
An object with class s2_geography
}
\description{
Geography vectors are arrays of points, lines, polygons, and/or collections
of these. Geography vectors assume coordinates are longitude and latitude
on a perfect sphere.
}
\details{
The coercion function \code{\link[=as_s2_geography]{as_s2_geography()}} is used to wrap the input
of most functions in the s2 package so that you can use other objects with
an unambiguious interpretation as a geography vector. Geography vectors
have a minimal \link[vctrs:vctrs-package]{vctrs} implementation, so you can
use these objects in \code{\link[tibble:tibble]{tibble::tibble()}} and other packages that use the vctrs
framework.
}
\seealso{
\code{\link[=s2_geog_from_wkb]{s2_geog_from_wkb()}}, \code{\link[=s2_geog_from_text]{s2_geog_from_text()}}, \code{\link[=s2_geog_point]{s2_geog_point()}},
\code{\link[=s2_make_line]{s2_make_line()}}, \code{\link[=s2_make_polygon]{s2_make_polygon()}} for other ways to
create geography vectors, and \code{\link[=s2_as_binary]{s2_as_binary()}} and \code{\link[=s2_as_text]{s2_as_text()}}
for other ways to export them.
}
