% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly.R
\name{hourly}
\alias{hourly}
\title{Hourly forecast for the next 24 hours.}
\usage{
hourly(location, use_metric = FALSE, key = get_api_key(), raw = FALSE,
  message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df with date, temperature, dew point,
        condition, wind speed and direction, UV index,
        humidity, windchill, heat index, real feel,
        rain, snow, pop, mslp
}
\description{
Hourly forecast for the next 24 hours.
}
\examples{
\dontrun{
hourly(set_location(territory = "Hawaii", city = "Honolulu"))
hourly(set_location(airport_code = "SEA"))
hourly(set_location(zip_code = "90210"))
hourly(set_location(territory = "IR", city = "Tehran"))
}
}
