\name{countriesCoarse}
\alias{countriesCoarse}
\docType{data}
\title{ a coarse resolution world map, a vector map of 244 country boundaries,suitable for global maps }
\description{
A 'SpatialPolygonsDataFrame' [package "sp"] object containing a simplified world map. 
Polygons are attributed with country codes.
244 countries. Based on Natural Earth data.
}
\usage{data(countriesCoarse)}
\format{
  The format is:
Formal class 'SpatialPolygonsDataFrame' [package "sp"] with 5 slots
  ..@ data       :'data.frame':	244 obs. of  51 variables:
  .. ..$ ISO3              : Factor w/ 238 levels "-99","AFG","AGO",..: 1 1 1 1 1 1 2 3 4 5 ...
  .. ..$ ScaleRank         : int [1:244] 5 1 1 1 1 1 1 1 1 1 ...
  .. ..$ LabelRank         : int [1:244] 5 1 1 1 1 1 1 1 1 1 ...
  .. ..$ FeatureCla        : Factor w/ 2 levels "Admin-0 countries",..: 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ SOVEREIGNT        : Factor w/ 204 levels "Afghanistan",..: 8 80 169 182 137 112 1 4 2 160 ...
  .. ..$ SOV_A3            : Factor w/ 205 levels "AFG","AGO","ALB",..: 8 86 133 182 141 38 1 2 3 4 ...
  .. ..$ ADM0_DIF          : num [1:244] 1 0 0 1 0 0 0 0 0 0 ...
  .. ..$ LEVEL             : num [1:244] 2 2 2 2 2 2 2 2 2 2 ...
  .. ..$ TYPE              : Factor w/ 7 levels "Country","County",..: 3 6 4 5 4 6 6 6 6 6 ...
  .. ..$ ADMIN             : Factor w/ 253 levels "Afghanistan",..: 205 83 174 234 141 116 1 4 2 164 ...
  .. ..$ ADM0_A3           : Factor w/ 253 levels "AFG","AGO","ALB",..: 204 89 137 207 145 39 1 2 3 4 ...
  .. ..$ GEOU_DIF          : num [1:244] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ GEOUNIT           : Factor w/ 253 levels "Afghanistan",..: 205 83 174 234 141 116 1 4 2 165 ...
  .. ..$ GU_A3             : Factor w/ 253 levels "AFG","AGO","ALB",..: 204 89 137 207 145 39 1 2 3 4 ...
  .. ..$ SU_DIF            : num [1:244] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ SUBUNIT           : Factor w/ 253 levels "Afghanistan",..: 205 83 174 234 141 116 1 4 2 165 ...
  .. ..$ SU_A3             : Factor w/ 253 levels "AFG","AGO","ALB",..: 204 89 137 207 145 39 1 2 3 4 ...
  .. ..$ NAME              : Factor w/ 250 levels "Afghanistan",..: 204 85 173 NA 144 109 1 4 2 165 ...
  .. ..$ ABBREV            : Factor w/ 247 levels "Afg.","Alb.",..: 203 85 173 NA 143 108 1 4 2 163 ...
  .. ..$ POSTAL            : Factor w/ 240 levels "A","AE","AF",..: 198 82 168 NA 138 33 3 5 4 2 ...
  .. ..$ NAME_FORMA        : Factor w/ 196 levels "Arab Republic of Egypt",..: NA NA NA NA 114 NA 30 55 54 NA ...
  .. ..$ TERR_             : Factor w/ 15 levels "Commonwealth of U.S.A.",..: 8 NA 3 NA NA NA NA NA NA NA ...
  .. ..$ NAME_SORT         : Factor w/ 253 levels "Afghanistan",..: 204 88 174 207 143 40 1 4 2 165 ...
  .. ..$ MAP_COLOR         : num [1:244] 7 11 4 0 2 8 7 1 6 3 ...
  .. ..$ POP_EST           : num [1:244] 4000 1804838 -99 6000 3500000 ...
  .. ..$ GDP_MD_EST        : num [1:244] 0 5352 900 0 -99 ...
  .. ..$ FIPS_10_          : num [1:244] -99 0 -99 -99 -99 -99 0 0 0 0 ...
  .. ..$ ISO_A2            : Factor w/ 237 levels "-99","AE","AF",..: 1 1 1 1 1 1 3 6 4 2 ...
  .. ..$ ISO_A3            : Factor w/ 238 levels "-99","AFG","AGO",..: 1 1 1 1 1 1 2 3 4 5 ...
  .. ..$ ISO_N3            : num [1:244] -99 -99 -99 -99 -99 -99 4 24 8 784 ...
  .. ..$ ISO2              : Factor w/ 222 levels "AD","AE","AF",..: NA NA NA NA NA NA 3 9 6 2 ...
  .. ..$ Name              : Factor w/ 232 levels "Afghanistan",..: NA NA NA NA NA NA 1 6 2 215 ...
  .. ..$ FIPS              : Factor w/ 222 levels "AA","AC","AE",..: NA NA NA NA NA NA 4 10 7 3 ...

  ..@ polygons   :List of 243

}
\details{
Derived fron version 1.4.0 of Natural Earth data 1:110 m data.      
Added in countries from the higher resolution data.

The different country boundaries in rworldmap are processed from Natural Earth Data as follows :
All :         
~ rename any non-ASCII country names that cause R trouble
~ rename Curacao which is particularly troublesome !
~ check polygon geometries using checkPolygonsHoles 
~ set projections, e.g. proj4string(countriesCoarse) <- CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
~ set polygon IDs to country names (from ADMIN field)
~ copy ISO_A3 to ISO3
~ replace missing ISO3 codes (6 in this version) with ADM0_A3
~ check for duplicate ISO3 codes (2 in this version)
~ set ISO3 for Gaza to Gaza and 'Ashmore and Cartier Islands' to Ashm
~ replace POP_EST of -99 with NA
~ join on countryRegions data

countriesCoarseLessIslands :  ne_110
countriesCoarse : ne_110 plus extra countries from ne_50 plus Tuvalu from ne_10
countriesLow :    ne_50 plus Tuvalu from ne_10
countriesHigh (in package rworldxtra) :   ne_10
}
\source{
http://www.naturalearthdata.com/downloads/110m-cultural-vectors/110m-admin-0-countries/
}
\examples{
data(countriesCoarse)
}
\keyword{datasets}
