% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_deps.R
\name{infer_deps}
\alias{infer_deps}
\title{Infer dependencies}
\usage{
infer_deps(
  path = here::here("DESCRIPTION"),
  which = c("Imports", "Suggests"),
  imports_thresh = 2,
  imports = NULL,
  suggests = c("testthat", "rmarkdown", "markdown", "knitr", "remotes", "knitr", "covr"),
  errors = c("reported", "fatal", "ignored"),
  dev = FALSE,
  progress = TRUE,
  add_newlines = FALSE
)
}
\arguments{
\item{path}{The path to a \code{.R}, \code{.Rmd}, \code{.qmd}, \code{DESCRIPTION}, a directory
containing such files, or an R function. The default uses all files
found within the current working directory and its children.}

\item{which}{Which types of dependencies to return.}

\item{imports_thresh}{The minimum number of times that a package has to be 
called within your package to assign it as an Import.
 If is called less times than this threshold, 
 it will instead be assigned as a Suggest, 
 which means it will not be installed by default.}

\item{imports}{R packages that are exempt from the \code{suggests_thresh}
rule and are instead automatically assigned as Imports.}

\item{suggests}{R packages that are exempt from the \code{suggests_thresh}
rule and are instead automatically assigned as Suggests.}

\item{errors}{How should errors that occur during dependency enumeration be
handled?
\itemize{
\item \code{"reported"} (the default): errors are reported to the user, but
otherwise ignored.
\item \code{"fatal"}: errors are fatal and stop execution.
\item \code{"ignored"}: errors are ignored and not reported to the user.
}}

\item{dev}{Boolean; include development dependencies? These packages are
typically required when developing the project, but not when running it
(i.e. you want them installed when humans are working on the project but
not when computers are deploying it).

Development dependencies include packages listed in the \code{Suggests} field
of a \code{DESCRIPTION} found in the project root, and roxygen2 or devtools if
their use is implied by other project metadata. They also include packages
used in \verb{~/.Rprofile} if \code{config$user.profile()} is \code{TRUE}.}

\item{progress}{Boolean; report progress output while enumerating
dependencies?}

\item{add_newlines}{Prefix each package name with a newline character 
and two spaces. This is useful for formatting \emph{DESCRIPTION} files.}
}
\value{
A character vector of R package names.
}
\description{
Infers the R packages that your R package depends on.
}
\examples{
#### Get example DESCRIPTION file ####
url <- "https://github.com/neurogenomics/templateR/raw/master/DESCRIPTION"
path <- tempfile(fileext = "DESCRIPTION")
utils::download.file(url,path)

deps <- infer_deps(path = path)
}
