% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvgamma.R
\name{rvgamma}
\alias{rvgamma}
\alias{rvngamma}
\title{Generate Random Variables from a Gamma Sampling Model}
\usage{
rvgamma(n = 1, shape, rate = 1, scale = 1/rate)
}
\arguments{
\item{n}{integer: number of variables to generate}

\item{shape}{shape parameter, may be a rv}

\item{rate}{rate parameter, may be a rv}

\item{scale}{inverse of rate, may be specified optionally instead of rate}
}
\value{
A random vector (rv object).
}
\description{
Generates random variables from a Gamma sampling model.
}
\details{
\code{rvngamma(n, shape, rate)} is equivalent to \code{rvgamma(n, 1/3 +
shape, rate)}.
}
\examples{

  round(rvmedian(rvngamma(n=1, shape=1:10, rate=1)), 1) ## close to 1:10

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
