% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_fetch_ds}
\alias{NCA_fetch_ds}
\title{Fetch Module Datasets}
\usage{
NCA_fetch_ds(state)
}
\arguments{
\item{state}{NCA state from \code{NCA_fetch_state()}}
}
\value{
list containing the following elements
\itemize{
\item{isgood:}    Return status of the function.
\item{hasds:}     Boolean indicator if the module has any datasets
\item{msgs:}      Messages to be passed back to the user.
\item{ds:}        List with datasets. Each list element has the name of
the R-object for that dataset. Each element has the following structure:
\itemize{
\item{label: Text label for the dataset}
\item{MOD_TYPE: Short name for the type of module.}
\item{id: module ID}
\item{DS: Dataframe containing the actual dataset.}
\item{DSMETA: Metadata describing DS}
\item{code: Complete code to build dataset.}
\item{checksum: Module checksum.}
\item{DSchecksum: Dataset checksum.}
}
}
}
\description{
Fetches the datasets contained in the module
}
\examples{
# We need a state object to use below
sess_res = NCA_test_mksession(session=list(), full_session=FALSE)
state = sess_res$state

myDs = NCA_fetch_ds(state)
}
