% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{MEM_loglik}
\alias{MEM_loglik}
\title{MEM log-likelihood (with skewness parameter)}
\usage{
MEM_loglik(param, x, daily_ret)
}
\arguments{
\item{param}{Vector of starting values.}

\item{x}{Dependent variable, usually the realized volatility. It must be positive and "xts" object.}

\item{daily_ret}{Daily returns, which must be an "xts" object, and with the same length of x.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{i,t}.
}
\description{
Obtains the log-likelihood of the base MEM, with an asymmetric term linked to past negative returns.
For details, see \insertCite{engle_gallo_2006;textual}{rumidas}.
}
\examples{
\donttest{
start_val<-c(alpha=0.10,beta=0.8,gamma=0.05)
real<-(rv5['/2010'])^0.5		# realized volatility
r_t<-sp500['/2010']
sum(MEM_loglik(start_val,real,r_t))
}
}
\references{
\insertAllCited{}
}
\keyword{internal}
