% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fit.R
\name{rule_fit}
\alias{rule_fit}
\alias{update.rule_fit}
\title{General Interface for RuleFit Models}
\usage{
rule_fit(
  mode = "unknown",
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  penalty = NULL
)

\method{update}{rule_fit}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  penalty = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{mtry}{An number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models.}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{tree_depth}{An integer for the maximum depth of the tree (i.e. number
of splits).}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration.}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further .}

\item{sample_size}{An number for the number (or proportion) of data that is
exposed to the fitting routine.}

\item{penalty}{L1 regularization parameter.}

\item{object}{A \code{rule_fit} model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main} parameters to update.
If the individual arguments are used, these will supersede the values in
parameters. Also, using engine arguments in this object will result in an
error.}

\item{fresh}{A logical for whether the arguments should be modified in-place
or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated \code{parsnip} model specification.
}
\description{
\code{\link[=rule_fit]{rule_fit()}} is a way to generate a \emph{specification} of a model
before fitting. The main arguments for the model are:
\itemize{
\item \code{mtry}: The number of predictors that will be
randomly sampled at each split when creating the tree models.
\item \code{trees}: The number of trees contained in the ensemble.
\item \code{min_n}: The minimum number of data points in a node
that are required for the node to be split further.
\item \code{tree_depth}: The maximum depth of the tree (i.e. number of
splits).
\item \code{learn_rate}: The rate at which the boosting algorithm adapts
from iteration-to-iteration.
\item \code{loss_reduction}: The reduction in the loss function required
to split further.
\item \code{sample_size}: The amount of data exposed to the fitting routine.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{\link[parsnip:set_engine]{parsnip::set_engine()}}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The RuleFit model creates a regression model of rules in two stages. The
first stage uses a tree-based model that is used to generate a set of rules
that can be filtered, modified, and simplified. These rules are then added
as predictors to a regularized generalized linear model that can also
conduct feature selection during model training.

For the \code{xrf} engine, the \code{xgboost} package is used to create the rule set
that is then added to a \code{glmnet} model.

The only available engine is \code{"xrf"}. Not that, per the documentation in
\code{?xrf}, transformations of the response variable are not supported. To
use these with \code{rule_fit()}, we recommend using a recipe instead of the
formula method.
}
\examples{
rule_fit()
# Parameters can be represented by a placeholder:
rule_fit(trees = 7)

# ------------------------------------------------------------------------------

set.seed(6907)
rule_fit_rules <-
  rule_fit(trees = 3, penalty = 0.1) \%>\%
  set_mode("classification") \%>\%
  fit(Species ~ ., data = iris)

# ------------------------------------------------------------------------------

model <- rule_fit(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)
}
\references{
Friedman, J. H., and Popescu, B. E. (2008). "Predictive learning
via rule ensembles." \emph{The Annals ofApplied Statistics}, 2(3), 916-954.
}
\seealso{
\code{\link[parsnip:fit]{parsnip::fit()}}, \code{\link[parsnip:fit_xy]{parsnip::fit_xy()}}, \code{\link[xrf:xrf.formula]{xrf::xrf.formula()}}
}
