% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ucm}
\alias{ucm}
\title{Unobserved components methods for a time series}
\usage{
ucm(formula, data, irregular = TRUE, irregular.var = NA, level = TRUE,
  level.var = NA, slope = FALSE, slope.var = NA, season = FALSE,
  season.length = NA, season.var = NA, cycle = FALSE, cycle.period = NA,
  cycle.var = NA)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} containing the symbolic description of the model with dependent and independent terms. If there are no independent terms, replace rhs with 0.}

\item{data}{a required data frame or list containing variables in the model.}

\item{irregular}{logical; if irregular component is to be included in the model. Defaults to \code{TRUE}.}

\item{irregular.var}{value to fix variance of irregular component.}

\item{level}{logical; if level is to be included in the model. Defaults to \code{TRUE}.}

\item{level.var}{value to fix variance of level component.}

\item{slope}{logical; if slope is to be included in the model along with level. Defaults to \code{FALSE}.}

\item{slope.var}{value to fix variance of the slope component.}

\item{season}{logical; if seasonal component is to be included in the model. Defaults to \code{FALSE}.}

\item{season.length}{value of length of seasonal component. Required when \code{season} is included.}

\item{season.var}{value to fix variance of seasonal component.}

\item{cycle}{logical; if cyclical component is to be included in the model. Defaults to \code{FALSE}.}

\item{cycle.period}{length of cyclical component. Required when \code{cycle} is included.}

\item{cycle.var}{value to fix variance of cyclical component.}
}
\value{
object of class \code{ucm}, which is a list with the following components:
\item{est}{Estimates of predictor variables, if present.}
\item{irr.var}{Estimated variance of irregular component, if present.}
\item{est.var.level}{Estimated variance of the level component, if present.}
\item{est.var.slope}{Estimated variance of slope of the level, if present.}
\item{est.var.season}{Estimated variance of the seasonal component, if present.}
\item{est.var.cycle}{Estimated variance of the cyclical component, if present.}
\item{s.level}{An object of the same class as of dependent variable containing the time varying level values, if level is present.}
\item{s.lope}{An object of the same class as of dependent variable containing the time varying slope values, if slope is present.}
\item{s.season}{An object of the same class as of dependent variable containing the time varying seasonal values, if season is present.}
\item{s.cycle}{An object of the same class as of dependent variable containing the time varying cyclical values, if cycle is present.}
\item{vs.level}{A vector containing time varying estimated variance of level, if level is present.}
\item{vs.slope}{A vector containing time varying estimated variance of slope, if slope is present.}
\item{vs.season}{A vector containing time varying estimated variance of seasonal component, if season is present.}
\item{vs.cycle}{A vector containing time varying estimated variance of cyclical component, if cycle is present.}
\item{call}{Original call of the function.}
\item{model}{The original model of class \code{\link{SSModel}} from \code{\link{KFAS}} package.}
}
\description{
Function \code{ucm} decomposes a time series into components such as trend, seasonal, cycle, and the regression effects due to predictor series using Unobserved Components Model (UCM).
}
\details{
Formula of the model can be of the forma as in \code{lm} with response variable on rhs and predictor variables or 0 (if no predictor variables) on the rhs.
}
\examples{
modelNile <- ucm(Nile~0, data = Nile, slope = TRUE)
modelNile
modelNile$s.level
}
\seealso{
\code{\link{KFAS}}, \code{\link{SSModel}} for a detailed discussion on State Space Models.
}

