% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{lookup_users}
\alias{lookup_users}
\title{lookup_users}
\usage{
lookup_users(users, token = NULL, parse = TRUE, tw = TRUE,
  clean_tweets = TRUE, as_double = FALSE)
}
\arguments{
\item{users}{User id or screen name of target user.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable @describeIn tokens.}

\item{parse}{Logical, indicating whether or not to parse
return object into data frame(s).}

\item{tw}{Logical indicating whether to return tweets data frame.
Defaults to true.}

\item{clean_tweets}{logical indicating whether to remove non-ASCII
characters in text of tweets. defaults to TRUE.}

\item{as_double}{logical indicating whether to handle ID variables
as double (numeric) class. By default, this is set to FALSE, meaning
ID variables are treated as character vectors. Setting this to
TRUE can provide performance (speed and memory) boost but can also
lead to issues when printing and saving, depending on the format.}
}
\value{
json response object (max is 18000 per token)
}
\description{
Returns Twitter user data_frame object for
  specified user_ids or screen_names.
}
\examples{
\dontrun{
# lookup vector of 1 or more user_id or screen_name
users <- c("potus", "hillaryclinton", "realdonaldtrump",
  "fivethirtyeight", "cnn", "espn", "twitter")

usr_df <- lookup_users(users)
usr_df

# view tweet data for these users via tweets_data()
tweets_data(usr_df)
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other users: \code{\link{search_users}},
  \code{\link{users_data}}
}

