% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followers.R
\name{get_followers}
\alias{get_followers}
\title{get_followers}
\usage{
get_followers(user, token = NULL, page = "-1")
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable.}

\item{page}{Default \code{page = -1} specifies first page of json
results. Other pages specified via cursor values supplied by
Twitter API response object.}
}
\value{
list of follower ids and next page value (presumably
  this would be used in loops extracting more than 75,000
  followers using either multiple tokens or by waiting out
  rate limits)
}
\description{
Returns max followers per token
}
\examples{
\dontrun{
# get ids of users following the president of the US
pres <- get_followers(user = "potus")
pres

# get ids of users following the Environmental Protection Agency
epa <- get_followers(user = "epa")
epa
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}
}

