% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.r
\name{getSymbols}
\alias{getSymbols}
\title{Download historical data}
\usage{
getSymbols(Symbols = NULL, env = parent.frame(),
  reload.Symbols = FALSE, verbose = FALSE, warnings = TRUE,
  src = "yahoo", symbol.lookup = TRUE, auto.assign = TRUE,
  from = "1990-01-01", to = Sys.time(), calendar = NULL,
  check.update = NULL)
}
\arguments{
\item{Symbols}{list symbols to download historical data}

\item{env}{environment to hold historical data, \strong{defaults to parent.frame()}}

\item{reload.Symbols}{flag, not used, inherited from the getSymbols function from 'quantmod' package, \strong{defaults to FALSE}}

\item{verbose}{flag, inherited from the getSymbols function from 'quantmod' package, \strong{defaults to FALSE}}

\item{warnings}{flag, not used, inherited from the getSymbols function from 'quantmod' package, \strong{defaults to TRUE}}

\item{src}{source of historical data, \strong{defaults to 'yahoo'}}

\item{symbol.lookup}{flag, not used, inherited from the getSymbols function from 'quantmod' package, \strong{defaults to TRUE}}

\item{auto.assign}{flag to store data in the given environment, \strong{defaults to TRUE}}

\item{from}{start date, expected in yyyy-mm-dd format, \strong{defaults to 1900-01-01}}

\item{to}{end date, expected in yyyy-mm-dd format, \strong{defaults to today's date}}

\item{calendar}{RQuantLib's holiday calendar, for example: calendar = 'UnitedStates/NYSE', \strong{defaults to NULL}}

\item{check.update}{flag to check for updates, \strong{defaults to NULL}}
}
\value{
xts object with data
}
\description{
Overwrite the getSymbols function from 'quantmod' package to efficiently 
load historical data
}
\examples{
 # small toy example

 # register data source to generate fake stock data for use in rtsdata examples
 register.data.source(src = 'sample', data = ds.getSymbol.fake.stock.data)
 
 # Full Update till '2018-02-13'
 data = getSymbols('test', src = 'sample', from = '2018-01-01', to = '2018-02-13', 
					auto.assign=FALSE, verbose=TRUE)
 
 # No updated needed, data is loaded from file
 data = getSymbols('test', src = 'sample', from = '2018-01-01', to = '2018-02-13', 
					auto.assign=FALSE, verbose=TRUE)

 # Incremental update from '2018-02-13' till today
 data = getSymbols('test', src = 'sample', from = '2018-01-01', 
					auto.assign=FALSE, verbose=TRUE)

 # No updated needed, data is loaded from file
 data = getSymbols('test', src = 'sample', from = '2018-01-01', 
					auto.assign=FALSE, verbose=TRUE)

	# data is stored in the 'sample_Rdata' folder at the following location
	ds.default.location()
 
 \donttest{ 
 ds.getSymbol.yahoo('AAPL',from='2018-02-13')
 }

}
