\name{ModisDownload}
\alias{ModisDownload}
\alias{getMODIS}
\alias{mosaicHDF}
\alias{reprojectHDF}
\alias{modisProducts}
\alias{setNASAauth}
\alias{getNativePixelSize}
\alias{getNativeTemporalResolution}

\alias{ModisDownload,character-method}
\alias{ModisDownload,numeric-method}
\alias{mosaicHDF,character-method}
\alias{mosaicHDF,numeric-method}
\alias{reprojectHDF,character-method}
\alias{reprojectHDF,numeric-method}
\alias{getMODIS,character-method}
\alias{getMODIS,numeric-method}
\alias{setNASAauth,ANY-method}
\title{Download, reproject, and mosaic Modis satellite images}

\description{
'ModisDownload' downloads a series of MODIS images in a specific date or a period of times, and for specified tile(s). It can also use MODIS Reproject Tool (MRT) software to mosaic the downloaded images, in case of selecting more than one tile, and reproject them to a specified coordinate system. As the format of the source images in LP DAAC is HDF, this tool can also convert them into other formats (i.e. Geotif, hdr).
}

\usage{
setNASAauth(username,password,update,...)

ModisDownload(x,h,v,dates, ...)

getMODIS(x,h,v,dates,version='005',forceReDownload=TRUE,ncore='auto')

mosaicHDF(hdfNames,filename,MRTpath,bands_subset,delete=FALSE)

reprojectHDF(hdfName,filename,MRTpath,...)

modisProducts(version=NULL)

getNativePixelSize(product)

getNativeTemporalResolution(product)
}

\arguments{
\item{username}{ character; username for authentication}
\item{password}{ character; password for authentication}
\item{update}{ logical; specifies whether .nerc file that has been previously created by setNASAauth, should be updated}
  \item{x}{ product name or a number specifies the product row in the data.frame generated by \code{modisProduct} function. It can also be the http address of the product.}
  \item{h}{ together with \code{v} specify the position of the Modis image tile(s). Examples: h=15; h=c(14,15); v=c(4:7) }
  \item{v}{ see the above descriptopn for \code{h} }
  \item{dates}{ logical. Only relevant if more than one tile is selected}
  \item{hdfName}{the name of hdf file}
  \item{hdfNames}{the names of hdf files}
  \item{MRTpath}{Path to the bin folder into the installed directory of MRT software. It is needed only if you need to mosaic and/or reproject the images. Example: MRTpath="d:/MRT/bin"}
  \item{filename}{ the name of new file}
  \item{version}{ the product version. The default value is '005'}
  \item{bands_subset}{HDF-EOS input files contain several layers of data (bands). Through this argument you ca select a subset of bands. You need to know how many bands the product has, and which bands you want to be subset. Example: Suppose your image has 6 bands and you only need the second band. The parameter should be entered as: bands_subset="0 1 0 0 0 0".}
  \item{delete}{ Logical. If \code{TRUE}, the original HDF files will be deleted after mosaic or reproject into new files.}
  \item{forceReDownload}{logical, specify whether the product should be re-downloaded if it had been downloaded before. The downloaded products are cashed using a hash digest of the inputs. If the download is canceled mid-way and the same exact products are downloaded again, it can be useful to avoid re-downloading them.}
  
  \item{ncore}{numerical; specify the number of cores used to speed up the download; 'auto' can be used instead to detect the number of cores and use half of them}
  
  \item{product}{The product name; can be extracted from the \code{modisProduct} function}
  
  \item{...}{ additional arguments including:
  
  - \code{mosaic}: logical, if \code{TRUE}, the images (several tiles) are mosaic into a single image
  
  - \code{proj}: Logical. If \code{TRUE}, it means that you want to reproject the images. Then reprojectHDF function will be called to reproject the images. 
  
  - \code{UL}: Optional. Upper Left coordinate (x,y) in output coordinate system. Only if you want to spatially subset your images.
  
  - \code{LR}: Optional. Lower right coordinate(x,y). Only if you want to spatially subset your images.
  
  - \code{resample_type}: Resampling kernel type ("CUBIC_CONVOLUTION", "NEAREST_NEIGHBOR", or "BILINEAR"). The default is "NEAREST_NEIGHBOR".
  
  - \code{proj_type}: Output projection short name. Valid values are "AEA" (Albers EqualArea), "ER" (Equirectangular), "GEO" (Geographic), "IGH" (Interrupted Goode Homolosine), "HAM" (Hammer), "ISIN" (Integerized Sinusoidal), "LA" (Lambert Azimuthal Equal Area), "LCC" (Lambert Conformal Conic), "MERCAT" (Mercator), "MOL" (Molleweide), "PS" (Polar Stereographic), "SIN" (Sinusoidal), "TM" (Transverse Mercator), and "UTM" (Universal Transverse Mercator).
  
  - \code{proj_params}: Output projection parameters. This quoted, floating-point list includes up to 15 projection parameters, with each value separated by white space ("p1 p2 ... p15"). If there are fewer than 15 values specified in the list, the remaining values will be set to zero. Integer values will automatically be converted to floating point (See the MRT software manual for the details).
  
  - \code{datum}: Specifies the output projection datum. The default is "WGS84"
  
  - \code{utm_zone}: Valid only if "UTM" is selected for the proj_type.
  
  - \code{pixel_size}: Output pixel size.
  
  }
}
\details{
To be able to download the data, you need to register on "https://urs.earthdata.nasa.gov/" and get a username and password. To pass the authentication by the website, you need to set the username and password on the machine (only first time) using \code{setNASAauth} function. Just specify the username and password in the function for the first time, and then the ModisDownload function can use it everytime you need to download the data.


To have the functionality for Mosaic and reprojecting of the images, you need to first install MRT software on your machine, and introduce its' path through the MRTpath argument. Otherwise, it can only be used for automating the downloading procedure.

The functions \code{ModisDownload} uses the functions including  \code{getMODIS}, \code{mosaicHDF}  (if needed), and \code{reprojectHDF}  (if needed). The functions \code{getMODIS}, can be used to download HDF files, while  \code{mosaicHDF} and \code{reprojectHDF} can mosaic and reproject the HDF files, respectively.

}


\author{Babak Naimi & Pablo Alfaro

\email{naimi.b@gmail.com}

\url{http://r-gis.net}
}



\examples{
\dontrun{
library(raster)

library(RCurl)

# First, you need to register on https://urs.earthdata.nasa.gov/ and get a username and password
# for the first time, set the authentication info:

setNASAauth(username='myusername',password='mypass') 

# product list:


modisProducts(version=5)
modisProducts(version=6)
modisProducts(version=NULL) # both versions

#x=3 # or x="MOD14A1"

# download 4 tiles (h14v04, h14v05, h15v04, h15v05) in single date (2011.05.01)

# Following command only downloads the source HDF images, no mosaic and no projection

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates='2011.05.01',mosaic=F,proj=F)

 
# alternatively, you can use modisHDF to download only HDF images:

modisHDF(x=x,h=c(17,18),v=c(4,5),dates='2011.05.01')

# same as the above command, but downloads all available images in 2011:

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates=c('2011.01.01','2011.12.31'))

#------

# Downloads selected tiles, and mosaic them, but no projections:

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates=c('2011.05.01','2011.05.31'),
              MRTpath='d:/MRT/bin',mosaic=T,proj=F)

#--- alternatively, you can first download the HDF images using getMODIS, 
#and then mosaic them using mosaicHDF!

# Downloads selected tiles, and mosaic, reproject them in UTM_WGS84, zone 30 projection and 
#convert all bands into Geotif format (the original HDF will be deleted!):

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates=c('2011.05.01','2011.05.31'),MRTpath='d:/MRT/bin',
              mosaic=T,proj=T,proj_type="UTM",utm_zone=30,datum="WGS84",pixel_size=1000)

# Same as above command, but only second band out of 6 bands will be kept. (You do not need 
#to specify proj_params when "UTM" is selected as proj_type and the zone also is specified,
#but for other types of projections you do).

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates=c('2011.05.01','2011.05.31'),MRTpath='d:/MRT/bin',
              mosaic=T,proj=T, bands_subset="0 1 0 0 0 0", proj_type="UTM",
              proj_params="-3 0 0 0 0 0 0 0 0 0 0 0 0 0 0",utm_zone=30,
              datum="WGS84",pixel_size=1000)

 
# Same as above command, but it spatially subsets the images into the specified box (UL and LR):

ModisDownload(x=x,h=c(17,18),v=c(4,5),dates=c('2011.05.01','2011.05.31'),MRTpath='d:/MRT/bin',
             mosaic=T,proj=T,UL=c(-42841.0,4871530.0),LR=c(1026104,3983860), 
             bands_subset="0 1 0 0 0 0", proj_type="UTM",
             proj_params="-3 0 0 0 0 0 0 0 0 0 0 0 0 0 0",utm_zone=30,datum="WGS84",
             pixel_size=1000)


}

}

\keyword{ utilities }