% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tdf.R
\name{count_summary}
\alias{count_summary}
\title{Compute a summary of counts}
\usage{
count_summary(x, count.id = "count", site.id = "site", time.id = "time",
  eps = 1e-08)
}
\arguments{
\item{x}{A \code{data.frame} with annual counts per site.}

\item{count.id}{\code{[character|numeric]}  index of the column containing the counts}

\item{site.id}{\code{[character|numeric]}  index of the column containing the site id's}

\item{time.id}{\code{[character|numeric]}  index of the column containing the time codes}

\item{eps}{\code{[numeric]} Numbers smaller then \code{eps} are treated a zero.}
}
\value{
A \code{list} of class \code{count.summary} containing individual names.
}
\description{
Summarize counts over a trim input dataset. Sites without counts are removed
before any counting takes place (since these will not be used when calling
\code{\link{trim}}). For the remaining records, the total number of
zero-counts, positive counts, total number of observed counts and the total
number of missings are reported.
}
\examples{
data(skylark)
count_summary(skylark)

s <- count_summary(skylark)
s$zero_counts # obtain number of zero counts
}

