% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{get_account_favourites}
\alias{get_account_favourites}
\title{Get favourites of user}
\usage{
get_account_favourites(
  max_id,
  min_id,
  limit = 40L,
  token = NULL,
  parse = TRUE,
  retryonratelimit = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{max_id}{character, Return results older than this id}

\item{min_id}{character, Return results younger than this id}

\item{limit}{integer, Maximum number of results to return}

\item{token}{user bearer token (read from file by default)}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}

\item{retryonratelimit}{If TRUE, and a rate limit is exhausted, will wait until it refreshes. Most Mastodon rate limits refresh every 5 minutes. If FALSE, and the rate limit is exceeded, the function will terminate early with a warning; you'll still get back all results received up to that point.}

\item{verbose}{logical whether to display messages}
}
\value{
tibble or list of favourited statuses
}
\description{
Get favourites of user
}
\details{
this functions needs a user level auth token. If limit>40, automatic pagination is used. You may get more results than requested.
}
\examples{
\dontrun{
# needs user level token
get_account_favourites()
}
}
