% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg_post_stat.R
\name{tg_post_stat}
\alias{tg_post_stat}
\title{Getting publication statistics}
\usage{
tg_post_stat(post_id, group = c("day", "hour"))
}
\arguments{
\item{post_id}{Post ID (t.me/username/123, t.me/c/1256804429/1230 or post ID in TGStat)}

\item{group}{Grouping results (hour, day)}
}
\value{
list with tibbles
}
\description{
Getting publication statistics
}
\details{
Obtaining publication statistics - the number of views at the moment, the list of reposts and mentions, the dynamics of the growth of views by hours / days.
}
\examples{
\dontrun{
post_stat <- tg_post_stat(
    post_id = 'https://t.me/R4marketing/887',
    group = 'day'
)

views <- post_stat$views
forwards <- post_stat$forwards
mentions <- post_stat$mentions
}
}
\references{
See also \href{https://api.tgstat.ru/docs/ru/posts/stat.html}{TGstat API Documentation of metrod posts/stat}
}
