% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enableAddon.R
\name{enableAddon}
\alias{enableAddon}
\alias{enableAddon,character-method}
\alias{enableAddon,SsimLibrary-method}
\title{Enable addon or addons.}
\usage{
enableAddon(ssimLibrary, name)

\S4method{enableAddon}{character}(ssimLibrary, name)

\S4method{enableAddon}{SsimLibrary}(ssimLibrary, name)
}
\arguments{
\item{ssimLibrary}{SsimLibrary}

\item{name}{Character string or vector of addon names}
}
\value{
This function invisibly returns `TRUE` upon success (i.e.successful activation of the addon 
and `FALSE` upon failure.
}
\description{
Enable addon or addons of an SsimLibrary.
}
\examples{
\donttest{
temp_dir <- tempdir()
myses <- session()
myLibrary <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)

enableAddon(myLibrary, c("stsim-ecological-departure"))
addon(myLibrary)
disableAddon(myLibrary, c("stsim-ecological-departure"))
addon(myLibrary)
}

}
