% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_votes.R
\name{votes}
\alias{votes}
\alias{cg_vote}
\alias{cg_votes_recent}
\alias{cg_votes_type}
\alias{cg_votes_date}
\alias{cg_votes_senatenoms}
\alias{cg_votes_explanations}
\alias{cg_votes_explanations_category}
\alias{cg_votes_explanations_member}
\alias{cg_votes_explanations_member}
\title{votes methods}
\usage{
cg_vote(congress, chamber, session, id, key = NULL, as = "table", ...)

cg_votes_recent(chamber, key = NULL, as = "table", ...)

cg_votes_type(congress, chamber, type, key = NULL, as = "table", ...)

cg_votes_date(chamber, year = NULL, month = NULL, start_date = NULL,
  end_date = NULL, key = NULL, as = "table", ...)

cg_votes_senatenoms(congress, key = NULL, as = "table", ...)

cg_votes_explanations(congress, votes = FALSE, key = NULL, as = "table",
  ...)

cg_votes_explanations_category(congress, category, key = NULL, as = "table",
  ...)

cg_votes_explanations_member(member_id, congress, votes = FALSE,
  category = NULL, key = NULL, as = "table", ...)

cg_votes_explanations_member(member_id, congress, votes = FALSE,
  category = NULL, key = NULL, as = "table", ...)
}
\arguments{
\item{congress}{(character) The number of the Congress this update
took place during.}

\item{chamber}{(character) The chamber this update took place in.
'house' or 'senate'.}

\item{session}{(integer) 1 or 2, depending on year (1 is odd-numbered
years, 2 is even-numbered years)}

\item{id}{(integer) roll call number, i.e., vote id}

\item{key}{your ProPublica API key; pass in or loads from environment variable
stored as \code{PROPUBLICA_API_KEY} in either your .Renviron, or similar file
locatd in your home directory}

\item{as}{(character) IGNORED FOR NOW}

\item{...}{optional curl options passed on to \link[crul:HttpClient]{crul::HttpClient}.
See \code{\link[curl:curl_options]{curl::curl_options()}}}

\item{type}{(character) the vote type, one of missed, party, loneno or perfect}

\item{year}{(integer) a four digit year of the form YYYY}

\item{month}{(integer) a 1 or 2 digit month}

\item{start_date, end_date}{(character) start and end date, of the form
YYYY-MM-DD}

\item{votes}{(logical) whether to return votes data or not. default: \code{FALSE}}

\item{category}{attribute describing the general reason for the absence or
incorrect vote. see Details.}

\item{member_id}{(character) The ID of the member to retrieve; it is
assigned by the Biographical Directory of the United States Congress
(http://bioguide.congress.gov/biosearch/biosearch.asp) or can be retrieved
from a \code{\link[=cg_members]{cg_members()}} request}
}
\value{
various things for now, since return objects vary quite a bit
among the different votes routes
}
\description{
votes methods
}
\section{Categories for the \code{category} parameter}{

\itemize{
\item voted-incorrectly: Voted yes or no by mistake
\item official-business: Away on official congressional business
\item ambiguous: No reason given
\item travel-difficulties: Travel delays and issues
\item personal:  Personal or family reason
\item claims-voted:  Vote made but not recorded
\item medical: Medical issue for lawmaker (not family)
\item weather: Inclement weather
\item memorial:  Attending memorial service
\item misunderstanding:  Not informed of vote
\item leave-of-absence:  Granted leave of absence
\item prior-commitment:  Attending to prior commitment
\item election-related:  Participating in an election
\item military-service:  Military service
\item other: Other
}
}

\examples{
\dontrun{
cg_vote(115, "senate", 1, 17)
cg_votes_recent("senate")
cg_votes_type(114, "house", "missed")
cg_votes_date("senate", year = 2017, month = 1)
cg_votes_date("senate", year = 2017, month = 3)
cg_votes_date("senate", start_date = "2017-01-03", end_date = "2017-01-31")
cg_votes_senatenoms(114)
cg_votes_explanations(114, votes = FALSE)
cg_votes_explanations(114, votes = TRUE)
cg_votes_explanations_category(114, "voted-incorrectly")
cg_votes_explanations_member("S001193", 115, votes = FALSE)
cg_votes_explanations_member("S001193", 115, votes = TRUE)
cg_votes_explanations_member("S001193", 115, votes = TRUE,
 category = "personal")
}
}
