/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.functions.AddedValueQF;
import org.vikamine.kernel.subgroup.quality.functions.AdjustedResidualQF;
import org.vikamine.kernel.subgroup.quality.functions.ChiSquareQF;
import org.vikamine.kernel.subgroup.quality.functions.LiftQF;
import org.vikamine.kernel.subgroup.quality.functions.PiatetskyShapiroQF;
import org.vikamine.kernel.subgroup.quality.functions.RelativeGainQF;
import org.vikamine.kernel.subgroup.quality.functions.StandardQF;
import org.vikamine.kernel.subgroup.quality.functions.WRAccQF;
import org.vikamine.kernel.subgroup.search.AbstractMiningTask;
import org.vikamine.kernel.subgroup.search.BSD;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.NumericBSD;
import org.vikamine.kernel.subgroup.search.SDBeamSearch;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.search.SDMapDisjunctive;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class SDSimpleTask
extends MiningTask {
    private static final String QF_ADJUSTED_RESIDUAL = "ares";
    private static final String QF_BINOMIAL = "bin";
    private static final String QF_CHI2 = "chi2";
    private static final String QF_GAIN = "gain";
    private static final String QF_LIFT = "lift";
    private static final String QF_PIATETSKY_SHAPIRO = "ps";
    private static final String QF_RELATIVE_GAIN = "relgain";
    private static final String QF_WRACC = "wracc";
    private static final String SD_METHOD_BEAM = "beam";
    private static final String SD_METHOD_BSD = "bsd";
    private static final String SD_METHOD_SDMAP = "sdmap";
    private static final String SD_METHOD_SDMAP_DISJUNCTIVE = "sdmap-dis";
    private static final String POST_FILTER_MIN_IMPROVEMENT_GLOBAL = "min-improve-global";
    private static final String POST_FILTER_MIN_IMPROVEMENT_SET = "min-improve-set";
    private static final String POST_FILTER_RELEVANCY = "relevancy";
    private static final String POST_FILTER_SIG_IMPROVEMENT_GLOBAL = "sig-improve-global";
    private static final String POST_FILTER_SIG_IMPROVEMENT_SET = "sig-improve-set";
    private static final String POST_FILTER_WEIGHTED_COVERING = "weighted-covering";
    private final List<SGFilters> sgFilters = new ArrayList<SGFilters>();
    private double postFilterParameter;

    public static String[] getSimpleDescription(SGDescription sgDescription) {
        ArrayList<String> result = new ArrayList<String>();
        for (SGSelector sel : sgDescription.getSelectors()) {
            result.add(sel.getDescription());
        }
        String[] strResult = new String[result.size()];
        strResult = result.toArray(strResult);
        return strResult;
    }

    public static String getAttributeIDOfSelector(SGSelector sel) {
        return sel.getAttribute().getId();
    }

    public static String getSingleValueIDOfSelector(SGSelector sel) {
        if (!(sel instanceof DefaultSGSelector)) {
            throw new UnsupportedOperationException("Selector " + sel + " is no DefaultSGSelector - this is currently not supported!");
        }
        DefaultSGSelector defaultSGSelector = (DefaultSGSelector)sel;
        Set<Value> values = defaultSGSelector.getValues();
        if (values.size() > 1) {
            throw new UnsupportedOperationException("Selector " + sel + " has more than one value: " + values + " - this is currently not supported!");
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next().getId();
    }

    public SDSimpleTask(Ontology ontology) {
        this.setOntology(ontology);
    }

    public SDSimpleTask(AbstractMiningTask oldTask) {
        super(oldTask);
    }

    public void setAttributes(String[] ids) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.checkAttribute(id)) {
                Attribute a = this.getOntology().getAttribute(id);
                attributes.add(a);
            }
            ++n2;
        }
        this.initializeSearchSpace(attributes);
    }

    private boolean checkAttribute(String attributeID) {
        if (this.getOntology().getAttribute(attributeID) == null) {
            throw new IllegalArgumentException("Attribute " + attributeID + " not found!");
        }
        if (this.target != null) {
            Attribute attribute = this.ontology.getAttribute(attributeID);
            if (this.target.getAttributes().contains(attribute)) {
                return false;
            }
        }
        return true;
    }

    private void checkNominalAttributeValue(String attributeID, String valueID) {
        this.checkAttribute(attributeID);
        Attribute a = this.getOntology().getAttribute(attributeID);
        if (!(a instanceof NominalAttribute)) {
            throw new IllegalArgumentException("Attribute " + a + " is not nominal!");
        }
        NominalAttribute nom = (NominalAttribute)a;
        if (nom.getNominalValueFromID(valueID) == null) {
            throw new IllegalArgumentException("Value " + valueID + " for attribute " + attributeID + " not found!");
        }
    }

    public void setNominalTarget(String attributeID, String valueID) {
        this.checkAttribute(attributeID);
        this.checkNominalAttributeValue(attributeID, valueID);
        DefaultSGSelector selector = new DefaultSGSelector(this.getOntology(), attributeID, valueID);
        this.setTarget(new SelectorTarget(selector));
    }

    public void setNumericTarget(String attributeID) {
        this.checkAttribute(attributeID);
        Attribute a = this.getOntology().getAttribute(attributeID);
        if (!a.isNumeric()) {
            throw new IllegalArgumentException(String.valueOf(attributeID) + " is not a numeric attributed");
        }
        this.setTarget(new NumericTarget((NumericAttribute)a));
    }

    private void check() {
        if (this.getInitialSG() == null) {
            this.initializeStartSubgroup();
        }
    }

    private void initializeSearchSpace(Collection<Attribute> attributes) {
        SGSelectorGenerator generator = this.isIgnoreDefaultValues() ? new SGSelectorGenerator.SimpleValueSelectorGeneratorIgnoreDefaults() : new SGSelectorGenerator.SimpleValueSelectorGenerator();
        ArrayList<SGSelector> newSearchSpace = new ArrayList<SGSelector>();
        for (Attribute att : attributes) {
            if (!att.isNominal()) continue;
            newSearchSpace.addAll(generator.getSelectors(att, this.getOntology().getDataView()));
        }
        this.setSearchSpace(newSearchSpace);
    }

    public void initializeStartSubgroup() {
        SG initialSG = new SG(this.getOntology().getDataView(), this.getTarget());
        initialSG.createStatistics(null);
        this.setInitialSG(initialSG);
    }

    public void setQualityFunction(String qf) {
        if (qf.equals(QF_ADJUSTED_RESIDUAL)) {
            this.setQualityFunction(new AdjustedResidualQF());
        } else if (qf.equals(QF_BINOMIAL)) {
            this.setQualityFunction(new StandardQF(0.5));
        } else if (qf.equals(QF_RELATIVE_GAIN)) {
            this.setQualityFunction(new RelativeGainQF());
        } else if (qf.equals(QF_GAIN)) {
            this.setQualityFunction(new AddedValueQF());
        } else if (qf.equals(QF_WRACC)) {
            this.setQualityFunction(new WRAccQF());
        } else if (qf.equals(QF_PIATETSKY_SHAPIRO)) {
            this.setQualityFunction(new PiatetskyShapiroQF());
        } else if (qf.equals(QF_LIFT)) {
            this.setQualityFunction(new LiftQF());
        } else if (qf.equals(QF_CHI2)) {
            this.setQualityFunction(new ChiSquareQF());
        } else {
            throw new IllegalArgumentException("Unknown quality function " + qf);
        }
    }

    public void setSDMethod(String method) {
        if (method.equals(SD_METHOD_SDMAP)) {
            this.setMethodType(SDMap.class);
        } else if (method.equals(SD_METHOD_SDMAP_DISJUNCTIVE)) {
            this.setMethodType(SDMapDisjunctive.class);
        } else if (method.equals(SD_METHOD_BSD)) {
            this.setMethodType(BSD.class);
        } else if (method.equals(SD_METHOD_BEAM)) {
            this.setMethodType(SDBeamSearch.class);
        } else {
            throw new IllegalArgumentException("Unknown method " + method);
        }
    }

    public void setPostFilter(String postFilter) {
        if (postFilter == null) {
            return;
        }
        double postFilterParameterDefault = this.postFilterParameter;
        if (postFilterParameterDefault < 0.0) {
            throw new IllegalStateException("Postfilter Parameter (parfilter) should be positive, but it is: " + postFilterParameterDefault);
        }
        if (postFilter.equals(POST_FILTER_MIN_IMPROVEMENT_GLOBAL)) {
            this.sgFilters.add(new SGFilters.MinImprovementFilterGlobal(postFilterParameterDefault));
        } else if (postFilter.equals(POST_FILTER_MIN_IMPROVEMENT_SET)) {
            this.sgFilters.add(new SGFilters.MinImprovementFilterOnSGSet(postFilterParameterDefault));
        } else if (postFilter.equals(POST_FILTER_SIG_IMPROVEMENT_GLOBAL)) {
            this.sgFilters.add(new SGFilters.SignificantImprovementFilterGlobal(postFilterParameterDefault));
        } else if (postFilter.equals(POST_FILTER_SIG_IMPROVEMENT_SET)) {
            this.sgFilters.add(new SGFilters.SignificantImprovementFilterOnSet(postFilterParameterDefault));
        } else if (postFilter.equals(POST_FILTER_RELEVANCY)) {
            this.sgFilters.add(new SGFilters.RelevancyFilter());
        } else if (postFilter.equals(POST_FILTER_WEIGHTED_COVERING)) {
            this.setWeightedCovering(true);
        } else {
            throw new IllegalArgumentException("Unknown post-filter " + postFilter);
        }
    }

    public void setPostFilterParameter(double param) {
        this.postFilterParameter = param;
    }

    @Override
    public SGSet performSubgroupDiscovery() {
        if (this.getMethodType().equals(BSD.class) && this.getTarget().isNumeric()) {
            this.setMethodType(NumericBSD.class);
        }
        this.check();
        SGSet result = super.performSubgroupDiscovery(this.sgFilters);
        return result;
    }
}

