/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SDBeamSearchDisjunctive
extends SDMethod {
    private static final String NAME = "SDBEAMSearchDisjunctive";
    protected boolean hasImproved = false;
    private List iterationSubgroupResults;

    private void expandBeamUsingAttribute(SG sg, Attribute attr, KBestSGSet resultSGSet) {
        for (SGSelector sel : this.selectorsCache) {
            SG currentSG;
            SGDescription currentSGD;
            if (!sel.getAttribute().equals(attr) || !this.addSGSelector(currentSGD = (currentSG = (SG)sg.clone()).getSGDescription(), attr, sel) || resultSGSet.contains(currentSG)) continue;
            currentSG.createStatistics(this.getOptions());
            currentSG.updateQuality(this.task.getQualityFunction());
            if (!this.doAddSubgroup(resultSGSet, currentSG)) continue;
            this.addSGToSGSet(resultSGSet, currentSG);
            this.hasImproved = true;
        }
    }

    private Set getAllValues(SGNominalSelector sel) {
        HashSet<Value> result = new HashSet<Value>();
        Value val = sel.getValues().iterator().next();
        if (val instanceof SingleValue) {
            result.add(val);
        }
        return result;
    }

    protected boolean addSGSelector(SGDescription sgd, Attribute attr, SGSelector sel) {
        if (sgd.containsAttributeAsSelector(attr)) {
            SGNominalSelector contained = (SGNominalSelector)sgd.removeSGSelectorForAttribute(attr);
            if (sel.equals(contained)) {
                sgd.add(contained);
                return false;
            }
            Set selValues = this.getAllValues((SGNominalSelector)sel);
            Set containedValues = this.getAllValues(contained);
            if (containedValues.size() - selValues.size() == 1 && !containedValues.containsAll(selValues)) {
                sgd.add(contained);
                return false;
            }
        }
        if (!sgd.contains(sel)) {
            sgd.add(sel);
            return true;
        }
        return false;
    }

    private KBestSGSet beam(KBestSGSet currentSGSet, SGTarget target) {
        this.hasImproved = false;
        KBestSGSet resultSGSet = (KBestSGSet)SGSets.copySGSet(currentSGSet);
        for (SG sg : currentSGSet) {
            SGDescription sgd = sg.getSGDescription();
            if (sgd.size() >= this.task.getMaxSGDSize()) break;
            for (Attribute attr : this.task.getAttributes()) {
                if (!this.isValidAttribute(attr, target)) continue;
                this.expandBeamUsingAttribute(sg, attr, resultSGSet);
            }
        }
        return resultSGSet;
    }

    private void addSGToSGSet(KBestSGSet resultSGSet, SG currentSG) {
        resultSGSet.addByReplacingWorstSG(currentSG);
        if (this.task.isSuppressStrictlyIrrelevantSubgroups()) {
            SGSets.removeIrrelevantSubgroupsFromSGSet(resultSGSet);
        }
    }

    protected boolean doAddSubgroup(KBestSGSet sgSet, SG currentSG) {
        return sgSet.isInKBestQualityRange(currentSG.getQuality()) && !sgSet.contains(currentSG) && (!this.task.isSuppressStrictlyIrrelevantSubgroups() || !SGSets.isSGStrictlyIrrelevant(currentSG, sgSet));
    }

    protected boolean isValidAttribute(Attribute attr, SGTarget target) {
        return attr.isNominal() && !target.getAttributes().contains(attr) && (this.task.getAttributes() == null || this.task.getAttributes().contains(attr));
    }

    protected List searchInternal(SG initialSubgroup) {
        this.iterationSubgroupResults = new LinkedList();
        KBestSGSet currentSGSet = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        double initQual = this.task.getQualityFunction().evaluate(initialSubgroup);
        SG clonedInitial = (SG)initialSubgroup.clone();
        clonedInitial.setQuality(initQual);
        currentSGSet.add(clonedInitial);
        int iteration = 1;
        do {
            this.hasImproved = false;
            KBestSGSet resultSGSet = this.beam(currentSGSet, initialSubgroup.getTarget());
            if (!this.hasImproved) continue;
            resultSGSet.setName(String.valueOf(this.getName()) + " i" + iteration);
            this.iterationSubgroupResults.add(resultSGSet);
            currentSGSet = resultSGSet;
            ++iteration;
        } while (this.hasImproved);
        KBestSGSet allIterationResultsSGSet = SGSets.createKBestSGSet(Integer.MAX_VALUE, this.task.getMinQualityLimit());
        for (SGSet sgSet : this.iterationSubgroupResults) {
            for (SG sg : sgSet) {
                if (allIterationResultsSGSet.contains(sg)) continue;
                allIterationResultsSGSet.add(sg);
            }
        }
        allIterationResultsSGSet.setName(String.valueOf(this.getName()) + " All");
        this.iterationSubgroupResults.add(0, allIterationResultsSGSet);
        return this.iterationSubgroupResults;
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        List multipleSets = this.searchInternal(initialSubgroup);
        return SGSets.mergeSGSetsToKBestSGSet(multipleSets, this.task.getMaxSGCount(), this.task.getMinQualityLimit());
    }

    public List<SGSet> getIterationResults() {
        if (this.iterationSubgroupResults == null) {
            throw new IllegalStateException("getIterationsResults was called before results were generated!");
        }
        return this.iterationSubgroupResults;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return true;
    }
}

