/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class InformationGainQF
extends AbstractQFStatisticBased {
    private static final String ID = "InformationGainQF";
    private static final String NAME = "Information Gain";

    @Override
    public double evaluate(SGStatistics statistics) {
        double nonSgNegatives;
        double nonSgPositives;
        double nonSgEntropy;
        double nonSgSize;
        double nonSgSizeRatio;
        double fp;
        double sgEntropy;
        if (statistics == null || !statistics.isBinary()) {
            throw new IllegalArgumentException("Statistics for subgroup were computed before or are not binary!");
        }
        SGStatisticsBinary stats = (SGStatisticsBinary)statistics;
        double size = stats.getDefinedPopulationCount();
        double positives = stats.getPositives();
        double negatives = stats.getNegatives();
        double populationEntropy = this.entropy(size, positives, negatives);
        double tp = stats.getTp();
        double sgSize = stats.getSubgroupSize();
        double sgSizeRatio = sgSize / size;
        double value = populationEntropy - (sgSizeRatio * (sgEntropy = this.entropy(sgSize, tp, fp = sgSize - tp)) + (nonSgSizeRatio = (nonSgSize = size - sgSize) / size) * (nonSgEntropy = this.entropy(nonSgSize, nonSgPositives = positives - tp, nonSgNegatives = negatives - fp)));
        if (Double.isNaN(value)) {
            value = Double.NEGATIVE_INFINITY;
        }
        return value;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new InformationGainQF();
    }

    protected double entropy(double size, double positive, double negative) {
        double posEnt = this.entropyPart(positive / size);
        double negEnt = this.entropyPart(negative / size);
        return posEnt + negEnt;
    }

    private double entropyPart(double p) {
        double logP = Math.log(p) / Math.log(2.0);
        return -p * logP;
    }
}

