% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ins.R
\name{make_path_norm}
\alias{make_path_norm}
\title{Normalize Path Add-in}
\usage{
make_path_norm()
}
\value{
normalized path string
}
\description{
Wrapper to execute \code{\link[fs:path_math]{fs::path_norm()}} as a shortcut on
highlighted text. The updated text will be converted in place to a path
normalized for the environment currently in use.
For instance, \ or \\\ will be converted to / on Windows machines.
See below for process of setting shortcut.
}
\details{
Add keyboard shortcut for \code{make_path_norm()} in RStudio, use the
\code{use_rstudio_keyboard_shortcut()} function. Do add it manually,
follow the instructions below.
\itemize{
\item Install rstudio.prefs, and restart RStudio
\item Select "Tools" --> "Modify Keyboard Shortcuts...".
\item In Search box, type "Make Path Normal".
\item Click in the "Shortcut" column on the "Make Path Normal" row.
\item Press intended shortcut keys (suggested: \verb{Ctrl+Shift+/}) to set shortcut.
\item NOTE: It is possible to override a previously specified key combination with this selection.
}
}
\examples{
if (interactive()) {
  # set a keyboard shortcut for path normalization
  rstudio.prefs::use_rstudio_keyboard_shortcut(
    "Ctrl+Shift+/" = "rstudio.prefs::make_path_norm"
  )
}
}
\seealso{
\link[fs:path_math]{fs::path_norm}
}
