% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstan_create_package.R
\name{rstan_create_package}
\alias{rstan_create_package}
\alias{rstan_package_skeleton}
\title{Create a new \R package with compiled Stan programs}
\usage{
rstan_create_package(path, fields = NULL, rstudio = TRUE,
  open = TRUE, stan_files = character(), roxygen = TRUE,
  travis = TRUE, license = TRUE, auto_config = TRUE)
}
\arguments{
\item{path}{The path to the new package to be created (terminating in the
package name).}

\item{fields, rstudio, open}{Same as \code{\link[usethis:create_package]{usethis::create_package()}}. See
the documentation for that function, especially the note in the
\strong{Description} section about the side effect of changing the active
project.}

\item{stan_files}{A character vector with paths to \code{.stan} files to include
in the package.}

\item{roxygen}{Should \pkg{roxygen2} be used for documentation?  Defaults to
\code{TRUE}. If so, a file `R/{pkgname}-package.R`` is added to the package with
roxygen tags for the required import lines. See the \strong{Note} section below
for advice specific to the latest versions of \pkg{roxygen2}.}

\item{travis}{Should a \code{.travis.yml} file be added to the package directory?
Defaults to \code{TRUE}.  While the file contains some presets to help with
compilation issues, at present it is not guaranteed to work on
\href{https://travis-ci.org/}{travis-ci} without manual adjustments.}

\item{license}{Logical or character; whether or not to paste the contents of
a \code{license.stan} file at the top of all Stan code, or path to such a
file.  If \code{TRUE} (the default) adds the \code{GPL (>= 3)} license (see
\strong{Details}).}

\item{auto_config}{Whether to automatically configure Stan functionality
whenever the package gets installed (see \strong{Details}). Defaults to \code{TRUE}.}
}
\description{
\if{html}{\figure{stanlogo.png}{options: width="25px" alt="https://mc-stan.org/about/logo/"}}
The \code{rstan_create_package()} function helps get you started developing a
new \R package that interfaces with Stan via the \pkg{rstan} package. First
the basic package structure is set up via \code{\link[usethis:create_package]{usethis::create_package()}}.
Then several adjustments are made so the package can include Stan programs
that can be built into binary versions (i.e., pre-compiled Stan C++ code).

The \strong{Details} section below describes the process and the
\strong{See Also} section provides links to recommendations for developers
and a step-by-step walk-through.

As of version \code{2.0.0} of \pkg{rstantools} the
\code{rstan_package_skeleton()} function is defunct and only
\code{rstan_create_package()} is supported.
}
\details{
This function first creates a regular \R package using
\code{usethis::create_package()}, then adds the infrastructure required to compile
and export \code{stanmodel} objects. In the package root directory, the user's
Stan source code is located in:
\preformatted{
inst/
  |_stan/
  |   |_include/
  |
  |_include/
}
All \code{.stan} files containing instructions to build a \code{stanmodel}
object must be placed in \code{inst/stan}.  Other \code{.stan} files go in
any \code{stan/} subdirectory, to be invoked by Stan's \code{#include}
mechanism, e.g.,
\preformatted{
#include "include/mylib.stan"
#include "data/preprocess.stan"
}
See \pkg{rstanarm} for many examples.

The folder \code{inst/include} is for all user C++ files associated with the
Stan programs.  In this folder, the only file to directly interact with the
Stan C++ library is \code{stan_meta_header.hpp}; all other \code{#include}
directives must be channeled through here.

The final step of the package creation is to invoke
\code{\link[=rstan_config]{rstan_config()}}, which creates the following files for
interfacing with Stan objects from \R:
\itemize{
\item \code{src} contains the \code{stan_ModelName{.cc/.hpp}} pairs
associated with all \code{ModelName.stan} files in \code{inst/stan} which
define \code{stanmodel} objects.
\item \code{src/Makevars[.win]} which link to the \code{StanHeaders} and
Boost (\code{BH}) libraries.
\item \code{R/stanmodels.R} loads the C++ modules containing the
\code{stanmodel} class definitions, and assigns an \R instance of each
\code{stanmodel} object to a \code{stanmodels} list (with names
corresponding to the names of the Stan files).
}

When \code{auto_config = TRUE}, a \code{configure[.win]} file is added to the
package, calling \code{\link[=rstan_config]{rstan_config()}} whenever the package is installed.
Consequently, the package must list \pkg{rstantools} in the \code{DESCRIPTION}
Imports field for this mechanism to work.  Setting \code{auto_config = FALSE}
removes the package's dependency on \pkg{rstantools}, but the package then
must be manually configured by running \code{\link[=rstan_config]{rstan_config()}} whenever
\code{stanmodel} files in \code{inst/stan} are added, removed, or modified.

In order to enable Stan functionality, \pkg{\link{rstantools}}
copies some files to your package.  Since these files are licensed as GPL

= 3, the same license applies to your package should you choose to
distribute it.  Even if you don't use \pkg{\link{rstantools}} to create
your package, it is likely that you will be linking to \pkg{\link{Rcpp}} to
export the Stan C++ \code{stanmodel} objects to \R.  Since
\pkg{\link{Rcpp}} is released under GPL >= 2, the same license would apply
to your package upon distribution.

Authors willing to license their Stan programs of general interest
under the GPL are invited to contribute their \code{.stan} files and
supporting \R code to the \pkg{rstanarm} package.
}
\note{
For \pkg{devtools} users, because of changes in the latest versions of
\pkg{roxygen2} it may be necessary to run \code{pkgbuild::compile_dll()}
once before \code{devtools::document()} will work.
}
\section{Using the pre-compiled Stan programs in your package}{
 The
\code{stanmodel} objects corresponding to the Stan programs included with your
package are stored in a list called \code{stanmodels}. To run one of the Stan
programs from within an R function in your package just pass the
appropriate element of the \code{stanmodels} list to one of the \pkg{rstan}
functions for model fitting (e.g., \code{sampling()}). For example, for a Stan
program \code{"foo.stan"} you would use \code{rstan::sampling(stanmodels$foo, ...)}.
}

\seealso{
\itemize{
\item \code{\link[=use_rstan]{use_rstan()}} for adding Stan functionality to an existing
\R package and \code{\link[=rstan_config]{rstan_config()}} for updating an existing package
when its Stan files are changed.
\item The \pkg{rstanarm} package \href{https://github.com/stan-dev/rstanarm}{repository}
on GitHub.
}

\itemize{
\item Guidelines and recommendations for developers of \R packages
interfacing with Stan and a demonstration getting a simple package working
can be found in the vignettes included with \pkg{rstantools} and at
\href{https://mc-stan.org/rstantools/articles/}{mc-stan.org/rstantools/articles}.
}

\itemize{
\item After reading the guidelines for developers, if you have trouble setting up
your package let us know on the the \href{https://discourse.mc-stan.org}{Stan Forums}
or at the \pkg{rstantools} GitHub \href{https://github.com/stan-dev/rstantools/issues}{issue tracker}.
}

\itemize{
\item The useR2016 presentation
\href{https://channel9.msdn.com/Events/useR-international-R-User-conferences/useR-International-R-User-2017-Conference/How-to-Use-RStan-to-Estimate-Models-in-External-R-Packages}{How to Use (R)Stan to Estimate Models in External R Packages.}
}
}
