% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstan_package_skeleton.R
\name{rstan_package_skeleton}
\alias{rstan_package_skeleton}
\title{Create a skeleton for a new \R package with Stan programs}
\usage{
rstan_package_skeleton(name = "anRpackage", list = character(),
  environment = .GlobalEnv, path = ".", force = FALSE,
  code_files = character(), stan_files = character(), travis = TRUE)
}
\arguments{
\item{name, list, environment, path, force, code_files}{Same as in
\code{\link[utils]{package.skeleton}}.}

\item{stan_files}{A character vector with paths to \code{.stan} files to
include in the package. Otherwise similar to \code{code_files}.}

\item{travis}{Should a \code{.travis.yml} file be added to the package
directory? Defaults to \code{TRUE}.}
}
\description{
This function is very similar to \code{\link[utils]{package.skeleton}} but is
designed for source packages that want to include Stan Programs that can be
built into binary versions.
}
\details{
This function first calls \code{\link[utils]{package.skeleton}} and
  then adds the files listed in \code{stan_files} to an exec directory.
  Finally, it downloads several files from the \pkg{rstanarm} package's
  \href{http://github.com/stan-dev/rstanarm}{GitHub repository} to facilitate
  building the resulting package. Note that \pkg{\link[rstanarm]{rstanarm}}
  is licensed under the GPL >= 3, so package builders who do not want to be
  governed by that license should not use the downloaded files that contain
  \R code. Otherwise, it may be worth considering whether it would be easier
  to include your \code{.stan} programs and supporting \R code in the
  \pkg{rstanarm} package.

  After running \code{rstan_package_skeleton} see the
  \code{Read-and-delete-me} file created in the package directory. The
  content in that file contains the content of the \code{Read-and-delete-me}
  file created by \code{\link[utils]{package.skeleton}} plus additional
  Stan-specific instructions.
}
\seealso{
The \pkg{rstanarm} repository on GitHub
  (\url{https://github.com/stan-dev/rstanarm}).

\itemize{
  \item The guidelines for developers of \R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}. The document is also available online at the
  \pkg{rstantools} page on the
  \href{https://CRAN.R-project.org/package=rstantools/vignettes/developer-guidelines.html}{CRAN
  website}.
}

\itemize{
  \item The \href{http://discourse.mc-stan.org}{Stan Forums} and the
  \href{https://github.com/stan-dev/rstantools/issues}{\pkg{rstantools} issue
  tracker} for assistance if you have trouble setting up your package.
}
}
