% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.stanreg}
\alias{compare}
\alias{loo}
\alias{loo.stanreg}
\alias{waic}
\alias{waic.stanreg}
\title{Leave-one-out cross-validation (LOO)}
\usage{
\method{loo}{stanreg}(x, ...)

\method{waic}{stanreg}(x, ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{Optional arguments to pass to \code{\link{psislw}}. Possible
  arguments and their defaults are:
\describe{
 \item{\code{wcp = 0.2}}{The proportion of importance weights to use for the
   generalized Pareto fit. The \code{100*wcp}\% largest weights are used as the
   sample from which to estimate the parameters \eqn{k} and \eqn{\sigma} of
   the generalized Pareto distribution.}
 \item{\code{wtrunc = 3/4}}{For truncating very large weights to
   \eqn{S}^\code{wtrunc} (set to zero for no truncation).}
 \item{\code{cores = getOption("loo.cores", parallel::detectCores())}}{The
 number of cores to use for parallelization. This can be set for an entire R
 session by \code{options(loo.cores = NUMBER)}. The default is
 \code{\link[parallel]{detectCores}}().}
}

 We recommend using the default values for the \code{psislw} arguments unless
 there are problems (e.g. \code{NA} or \code{NaN} results).}
}
\value{
An object of class 'loo'. See the 'Value' section in 
  \code{\link[loo]{loo}} and \code{\link[loo]{waic}} for details on the
  structure of these objects.
}
\description{
For models fit using MCMC, compute approximate leave-one-out cross-validation
(LOO) or, less preferably, the Widely Applicable Information Criterion (WAIC) 
using the \pkg{\link[=loo-package]{loo}} package. Compare two or more models 
using the \code{\link[loo]{compare}} function.
}
\details{
The LOO Information Criterion (LOOIC) has the same purpose as the Akaike 
Information Criterion (AIC) that is used by frequentists. Both are intended 
to estimate the expected log predictive density (ELPD) for a new dataset. 
However, the AIC ignores priors and assumes that the posterior distribution 
is multivariate normal, whereas the functions from the 
\pkg{\link[=loo-package]{loo}} package do not make this distributional 
assumption and integrate over uncertainty in the parameters. This only 
assumes that any one observation can be omitted without having a major effect
on the posterior distribution, which can be judged using the diagnostic plot 
provided by the \code{\link[loo]{plot.loo}} method. The \emph{How to Use the 
rstanarm Package} vignette has an example of this entire process.
}
\note{
The \code{...} is ignored for \code{waic}.
}
\examples{
\dontrun{
SEED <- 42024
set.seed(SEED)

fit1 <- stan_glm(mpg ~ wt, data = mtcars, seed = SEED)
fit2 <- update(fit1, formula = . ~ . + cyl)
(loo1 <- loo(fit1))
loo2 <- loo(fit2)
compare(loo1, loo2)
plot(loo2)


# dataset description at help("lalonde", package = "arm")
data(lalonde, package = "arm") 
t7 <- student_t(df = 7) # prior for coefficients

f1 <- treat ~ re74 + re75 + educ + black + hisp + married + 
   nodegr + u74 + u75
lalonde1 <- stan_glm(f1, data = lalonde, family = binomial(link="logit"), 
                     prior = t7, cores = 4, seed = SEED)
                 
f2 <- treat ~ age + I(age^2) + educ + I(educ^2) + black + hisp + 
   married + nodegr + re74  + I(re74^2) + re75 + I(re75^2) + u74 + u75   
lalonde2 <- update(lalonde1, formula = f2)

(loo_lalonde1 <- loo(lalonde1))
(loo_lalonde2 <- loo(lalonde2))
plot(loo_lalonde2, label_points = TRUE)
compare(loo_lalonde1, loo_lalonde2)
}

}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC.
\url{http://arxiv.org/abs/1507.04544/} (preprint)
}
\seealso{
\code{\link[loo]{compare}} for comparing two or more models on LOO and WAIC.

\code{\link[loo]{loo-package}} (in particular the \emph{PSIS-LOO} section) 
for details on the computations implemented by the \pkg{loo} package and the 
interpretation of the Pareto \eqn{k} estimates displayed when using the 
\code{\link{plot.loo}} method.
}

